/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.am.OIDCRPClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.jpa.dao.AbstractClientAppDAO;
import org.apache.syncope.core.persistence.jpa.entity.am.JPAOIDCRPClientApp;
import org.springframework.transaction.annotation.Transactional;

public class JPAOIDCRPClientAppDAO
extends AbstractClientAppDAO<OIDCRPClientApp>
implements OIDCRPClientAppDAO {
    public OIDCRPClientApp find(String key) {
        return (OIDCRPClientApp)this.entityManager().find(JPAOIDCRPClientApp.class, (Object)key);
    }

    private OIDCRPClientApp find(String column, Object value) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAOIDCRPClientApp.class.getSimpleName() + " e WHERE e." + column + "=:value", OIDCRPClientApp.class);
        query.setParameter("value", value);
        OIDCRPClientApp result = null;
        try {
            result = (OIDCRPClientApp)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No OIDCRP found with " + column + " {}", value, (Object)e);
        }
        return result;
    }

    public OIDCRPClientApp findByClientAppId(Long clientAppId) {
        return this.find("clientAppId", clientAppId);
    }

    public OIDCRPClientApp findByName(String name) {
        return this.find("name", name);
    }

    public OIDCRPClientApp findByClientId(String clientId) {
        return this.find("clientId", clientId);
    }

    public List<OIDCRPClientApp> findByPolicy(Policy policy) {
        return this.findByPolicy(policy, OIDCRPClientApp.class, JPAOIDCRPClientApp.class);
    }

    public List<OIDCRPClientApp> findByRealm(Realm realm) {
        return this.findByRealm(realm, OIDCRPClientApp.class, JPAOIDCRPClientApp.class);
    }

    @Transactional(readOnly=true)
    public List<OIDCRPClientApp> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAOIDCRPClientApp.class.getSimpleName() + " e", OIDCRPClientApp.class);
        return query.getResultList();
    }

    public OIDCRPClientApp save(OIDCRPClientApp clientApp) {
        ((JPAOIDCRPClientApp)clientApp).list2json();
        return (OIDCRPClientApp)this.entityManager().merge((Object)clientApp);
    }

    public void delete(String key) {
        OIDCRPClientApp rpTO = this.find(key);
        if (rpTO == null) {
            return;
        }
        this.delete(rpTO);
    }

    public void deleteByClientId(String clientId) {
        OIDCRPClientApp rpTO = this.findByClientId(clientId);
        if (rpTO == null) {
            return;
        }
        this.delete(rpTO);
    }

    public void delete(OIDCRPClientApp clientApp) {
        this.entityManager().remove((Object)clientApp);
    }
}

