/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentLoaderHandler
extends DefaultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ContentLoaderHandler.class);
    private static final String CONF_DIR = "syncope.conf.dir";
    private final JdbcTemplate jdbcTemplate;
    private final String rootElement;
    private final boolean continueOnError;
    private final Map<String, String> fetches = new HashMap<String, String>();
    private final StringSubstitutor paramSubstitutor;

    public ContentLoaderHandler(DataSource dataSource, String rootElement, boolean continueOnError, Environment env) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.rootElement = rootElement;
        this.continueOnError = continueOnError;
        this.paramSubstitutor = new StringSubstitutor(key -> {
            String value = env.getProperty(key, this.fetches.get(key));
            if (value != null && CONF_DIR.equals(key)) {
                value = value.replace('\\', '/');
            }
            return StringUtils.isBlank((CharSequence)value) ? null : value;
        });
    }

    private Object[] getParameters(String tableName, Attributes attrs) {
        Map colTypes = (Map)this.jdbcTemplate.query("SELECT * FROM " + tableName + " WHERE 0=1", rs -> {
            HashMap<String, Integer> types = new HashMap<String, Integer>();
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                types.put(rs.getMetaData().getColumnName(i).toUpperCase(), rs.getMetaData().getColumnType(i));
            }
            return types;
        });
        Object[] parameters = new Object[attrs.getLength()];
        block25: for (int i = 0; i < attrs.getLength(); ++i) {
            String value;
            Integer colType = (Integer)Objects.requireNonNull(colTypes).get(attrs.getQName(i).toUpperCase());
            if (colType == null) {
                LOG.warn("No column type found for {}", (Object)attrs.getQName(i).toUpperCase());
                colType = 12;
            }
            if ((value = this.paramSubstitutor.replace(attrs.getValue(i))) == null) {
                LOG.warn("Variable ${} could not be resolved", (Object)attrs.getValue(i));
                value = attrs.getValue(i);
            }
            value = StringEscapeUtils.unescapeXml((String)value);
            switch (colType) {
                case -6: 
                case 4: 
                case 5: {
                    try {
                        parameters[i] = Integer.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Integer '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case -5: 
                case 2: 
                case 3: {
                    try {
                        parameters[i] = Long.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Long '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case 8: {
                    try {
                        parameters[i] = Double.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Double '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case 6: 
                case 7: {
                    try {
                        parameters[i] = Float.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Float '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case -101: 
                case 91: 
                case 92: 
                case 93: 
                case 2014: {
                    try {
                        parameters[i] = FormatUtils.parseDate((String)value);
                    }
                    catch (DateTimeParseException e) {
                        LOG.error("Unparsable Date '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case -7: 
                case 16: {
                    parameters[i] = "1".equals(value) ? Boolean.TRUE : Boolean.FALSE;
                    continue block25;
                }
                case -4: 
                case -3: 
                case -2: {
                    try {
                        parameters[i] = DatatypeConverter.parseHexBinary((String)value);
                    }
                    catch (IllegalArgumentException e) {
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case 2004: {
                    try {
                        parameters[i] = DatatypeConverter.parseHexBinary((String)value);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Error decoding hex string to specify a blob parameter", (Throwable)e);
                        parameters[i] = value;
                    }
                    catch (Exception e) {
                        LOG.warn("Error creating a new blob parameter", (Throwable)e);
                    }
                    continue block25;
                }
                default: {
                    parameters[i] = value;
                }
            }
        }
        return parameters;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        block6: {
            if (this.rootElement.equals(qName)) {
                return;
            }
            if ("fetch".equalsIgnoreCase(qName)) {
                String value = (String)this.jdbcTemplate.queryForObject(atts.getValue("query"), String.class);
                String key = atts.getValue("key");
                this.fetches.put(key, value);
            } else {
                StringBuilder query = new StringBuilder("INSERT INTO ").append(qName).append('(');
                StringBuilder values = new StringBuilder();
                for (int i = 0; i < atts.getLength(); ++i) {
                    query.append(atts.getQName(i));
                    values.append('?');
                    if (i >= atts.getLength() - 1) continue;
                    query.append(',');
                    values.append(',');
                }
                query.append(") VALUES (").append((CharSequence)values).append(')');
                try {
                    this.jdbcTemplate.update(query.toString(), this.getParameters(qName, atts));
                }
                catch (DataAccessException e) {
                    LOG.error("While trying to perform {} with params {}", new Object[]{query, this.getParameters(qName, atts), e});
                    if (this.continueOnError) break block6;
                    throw e;
                }
            }
        }
    }
}

