/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.context.ApplicationContext;

public class DuoSecurityHealthIndicator
extends AbstractHealthIndicator {
    private final ApplicationContext applicationContext;

    protected void doHealthCheck(Health.Builder builder) {
        builder.withDetail("name", (Object)((Object)((Object)this)).getClass().getSimpleName());
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).forEach(p -> {
            DuoSecurityAuthenticationService duoService = p.getDuoAuthenticationService();
            boolean result = duoService.ping();
            Health.Builder b = builder.withDetail("duoApiHost", (Object)duoService.getProperties().getDuoApiHost());
            if (result) {
                b.up();
            } else {
                b.down();
            }
            b.build();
        });
    }

    @Generated
    public DuoSecurityHealthIndicator(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

