/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationExceptionHandlerAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationExceptionHandlerAction.class);
    private final List<CasWebflowExceptionHandler> webflowExceptionHandlers;

    protected Event doExecute(RequestContext requestContext) {
        Event currentEvent = requestContext.getCurrentEvent();
        LOGGER.debug("Located current event [{}]", (Object)currentEvent);
        Exception error = (Exception)currentEvent.getAttributes().get("error", Exception.class);
        if (error != null) {
            LOGGER.debug("Located error attribute [{}] with message [{}] from the current event", error.getClass(), (Object)error.getMessage());
            String event = this.handle(error, requestContext);
            LOGGER.debug("Final event id resolved from the error is [{}]", (Object)event);
            return new EventFactorySupport().event((Object)this, event, currentEvent.getAttributes());
        }
        return this.error();
    }

    public String handle(Exception e, RequestContext requestContext) {
        List handlers = this.webflowExceptionHandlers.stream().filter(handler -> handler.supports(e, requestContext)).collect(Collectors.toList());
        return handlers.stream().map(handler -> handler.handle(e, requestContext)).filter(Objects::nonNull).findFirst().orElseGet(() -> ((AuthenticationExceptionHandlerAction)this).error()).getId();
    }

    @Generated
    public AuthenticationExceptionHandlerAction(List<CasWebflowExceptionHandler> webflowExceptionHandlers) {
        this.webflowExceptionHandlers = webflowExceptionHandlers;
    }
}

