/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisionAuxClassesPanel
extends Panel {
    private static final long serialVersionUID = -3962956154520358784L;
    private static final Logger LOG = LoggerFactory.getLogger(ProvisionAuxClassesPanel.class);
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    protected final Provision provision;

    public ProvisionAuxClassesPanel(String id, Provision provision) {
        super(id);
        this.setOutputMarkupId(true);
        this.provision = provision;
    }

    protected void onBeforeRender() {
        List<String> choices;
        ListModel model;
        super.onBeforeRender();
        AnyTypeTO anyType = null;
        if (this.provision == null) {
            model = new ListModel(List.of());
            choices = List.of();
        } else {
            model = new PropertyModel((Object)this.provision, "auxClasses");
            choices = new ArrayList();
            try {
                anyType = this.anyTypeRestClient.read(this.provision.getAnyType());
            }
            catch (Exception e) {
                LOG.error("Could not read AnyType {}", (Object)this.provision.getAnyType(), (Object)e);
            }
            if (anyType != null) {
                for (AnyTypeClassTO aux : this.anyTypeClassRestClient.list()) {
                    if (anyType.getClasses().contains(aux.getKey())) continue;
                    choices.add(aux.getKey());
                }
            }
        }
        this.addOrReplace(new Component[]{new AjaxPalettePanel.Builder().build("auxClasses", (IModel)model, (IModel)new ListModel(choices)).hideLabel().setOutputMarkupId(true).setEnabled(this.provision != null)});
        AjaxTextFieldPanel uidOnCreate = new AjaxTextFieldPanel("uidOnCreate", new ResourceModel("uidOnCreate", "uidOnCreate").getObject(), (IModel)new PropertyModel((Object)this.provision, "uidOnCreate"));
        uidOnCreate.setChoices(this.getSchemas(anyType, (List)model.getObject()));
        uidOnCreate.setOutputMarkupId(true).setEnabled(this.provision != null);
        this.addOrReplace(new Component[]{uidOnCreate});
    }

    protected List<String> getSchemas(AnyTypeTO anyType, List<String> anyTypeClasses) {
        ArrayList<String> classes = new ArrayList<String>(anyType.getClasses());
        classes.addAll(anyTypeClasses);
        return this.schemaRestClient.getSchemas(SchemaType.PLAIN, null, (String[])classes.toArray(String[]::new)).stream().map(SchemaTO::getKey).collect(Collectors.toList());
    }
}

