/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openjpa.event.AbstractRemoteCommitProvider;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.GenericConfigurable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public class JMSRemoteCommitProvider
extends AbstractRemoteCommitProvider
implements Configurable,
GenericConfigurable,
ExceptionListener {
    private static Localizer s_loc = Localizer.forPackage(JMSRemoteCommitProvider.class);
    private String _topicName = "topic/OpenJPACommitProviderTopic";
    private String _tcfName = "java:/ConnectionFactory";
    private Properties _ctxProps = null;
    private int _reconnectAttempts = 0;
    private TopicConnection _connection;
    private TopicSession _session;
    private TopicPublisher _publisher;
    private ClassLoader _appClassLoader;

    public void setTopic(String name) {
        this._topicName = name;
    }

    public void setTopicConnectionFactory(String name) {
        this._tcfName = name;
    }

    public void setExceptionReconnectAttempts(int attempts) {
        this._reconnectAttempts = attempts;
    }

    public void setInto(Options opts) {
        if (opts != null && !opts.isEmpty()) {
            this._ctxProps = new Properties();
            this._ctxProps.putAll((Map<?, ?>)opts);
            opts.clear();
        } else {
            this._ctxProps = null;
        }
    }

    protected Context newContext() throws NamingException {
        if (this._ctxProps == null) {
            return new InitialContext();
        }
        return new InitialContext(this._ctxProps);
    }

    @Override
    public void broadcast(RemoteCommitEvent event) {
        block3: {
            try {
                this._publisher.publish(this.createMessage(event));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)s_loc.get("jms-sent-update", (Object)this._topicName));
                }
            }
            catch (JMSException jmse) {
                if (!this.log.isWarnEnabled()) break block3;
                this.log.warn((Object)s_loc.get("jms-send-error", (Object)this._topicName), (Throwable)jmse);
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this._connection != null) {
                this._connection.close();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)s_loc.get("jms-close-listener", (Object)this._topicName));
                }
            }
        }
        catch (JMSException jmse) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)s_loc.get("jms-close-error", (Object)this._topicName), (Throwable)jmse);
            }
        }
        finally {
            this._connection = null;
        }
    }

    @Override
    public void endConfiguration() {
        super.endConfiguration();
        this._appClassLoader = Thread.currentThread().getContextClassLoader();
        this.connect();
    }

    protected void connect() {
        try {
            Context ctx = this.newContext();
            TopicConnectionFactory tcf = (TopicConnectionFactory)ctx.lookup(this._tcfName);
            Topic topic = (Topic)ctx.lookup(this._topicName);
            ctx.close();
            this._connection = tcf.createTopicConnection();
            this._session = this._connection.createTopicSession(false, 1);
            this._publisher = this._session.createPublisher(topic);
            TopicSubscriber s = this._session.createSubscriber(topic, null, true);
            MessageListener l = this.getMessageListener();
            s.setMessageListener(l);
            this._connection.start();
            this._connection.setExceptionListener((ExceptionListener)this);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)s_loc.get("jms-start-listener", (Object)this._topicName));
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new UserException(s_loc.get("jms-provider-config", (Object)this._topicName, (Object)this._tcfName), (Throwable)e).setFatal(true);
        }
    }

    protected MessageListener getMessageListener() {
        return new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(Message m) {
                if (!(m instanceof ObjectMessage)) {
                    if (JMSRemoteCommitProvider.this.log.isWarnEnabled()) {
                        JMSRemoteCommitProvider.this.log.warn((Object)s_loc.get("jms-receive-error-3", (Object)JMSRemoteCommitProvider.this._topicName, (Object)m.getClass().getName()));
                    }
                    return;
                }
                ClassLoader saveCls = Thread.currentThread().getContextClassLoader();
                try {
                    ObjectMessage om;
                    Serializable o;
                    if (saveCls != JMSRemoteCommitProvider.this._appClassLoader) {
                        Thread.currentThread().setContextClassLoader(JMSRemoteCommitProvider.this._appClassLoader);
                    }
                    if ((o = (om = (ObjectMessage)m).getObject()) instanceof RemoteCommitEvent) {
                        if (JMSRemoteCommitProvider.this.log.isTraceEnabled()) {
                            JMSRemoteCommitProvider.this.log.trace((Object)s_loc.get("jms-received-update", (Object)JMSRemoteCommitProvider.this._topicName));
                        }
                        RemoteCommitEvent rce = (RemoteCommitEvent)o;
                        JMSRemoteCommitProvider.this.fireEvent(rce);
                    } else if (JMSRemoteCommitProvider.this.log.isWarnEnabled()) {
                        JMSRemoteCommitProvider.this.log.warn((Object)s_loc.get("jms-receive-error-2", (Object)o.getClass().getName(), (Object)JMSRemoteCommitProvider.this._topicName));
                    }
                }
                catch (JMSException jmse) {
                    if (JMSRemoteCommitProvider.this.log.isWarnEnabled()) {
                        JMSRemoteCommitProvider.this.log.warn((Object)s_loc.get("jms-receive-error-1"), (Throwable)jmse);
                    }
                }
                finally {
                    if (saveCls != JMSRemoteCommitProvider.this._appClassLoader) {
                        Thread.currentThread().setContextClassLoader(saveCls);
                    }
                }
            }
        };
    }

    protected Message createMessage(RemoteCommitEvent event) throws JMSException {
        return this._session.createObjectMessage((Serializable)event);
    }

    public void onException(JMSException ex) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)s_loc.get("jms-listener-error", (Object)this._topicName), (Throwable)ex);
        }
        if (this._reconnectAttempts <= 0) {
            return;
        }
        this.close();
        boolean connected = false;
        for (int i = 0; !connected && i < this._reconnectAttempts; ++i) {
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)s_loc.get("jms-reconnect-attempt", (Object)this._topicName, (Object)String.valueOf(i + 1)));
                }
                this.connect();
                connected = true;
                continue;
            }
            catch (Exception e) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)s_loc.get("jms-reconnect-fail", (Object)this._topicName), (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
        }
        if (!connected && this.log.isErrorEnabled()) {
            this.log.error((Object)s_loc.get("jms-cant-reconnect", (Object)this._topicName, (Object)String.valueOf(this._reconnectAttempts)));
        } else if (connected && this.log.isInfoEnabled()) {
            this.log.info((Object)s_loc.get("jms-reconnected", (Object)this._topicName));
        }
    }
}

