/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DisableCheckConstraintStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DisableCheckConstraintGenerator
extends AbstractSqlGenerator<DisableCheckConstraintStatement> {
    @Override
    public boolean supports(DisableCheckConstraintStatement disableCheckConstraintStatement, Database database) {
        return (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database) && !(database instanceof Db2zDatabase);
    }

    @Override
    public ValidationErrors validate(DisableCheckConstraintStatement disableCheckConstraintStatement, Database object, SqlGeneratorChain sqlGeneratorChain) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("tableName", disableCheckConstraintStatement.getTableName());
        ((ValidationErrors)object).checkRequiredField("constraintName", disableCheckConstraintStatement.getConstraintName());
        return object;
    }

    @Override
    public Sql[] generateSql(DisableCheckConstraintStatement disableCheckConstraintStatement, Database database, SqlGeneratorChain object) {
        object = new StringBuilder();
        ((StringBuilder)object).append("ALTER TABLE ");
        ((StringBuilder)object).append(database.escapeTableName(disableCheckConstraintStatement.getCatalogName(), disableCheckConstraintStatement.getSchemaName(), disableCheckConstraintStatement.getTableName()));
        if (database instanceof OracleDatabase) {
            ((StringBuilder)object).append(" DISABLE CONSTRAINT ").append(disableCheckConstraintStatement.getConstraintName());
        } else if (database instanceof AbstractDb2Database) {
            ((StringBuilder)object).append(" ALTER CHECK ").append(disableCheckConstraintStatement.getConstraintName()).append(" NOT ENFORCED");
        } else {
            ((StringBuilder)object).append(" NOCHECK CONSTRAINT ").append(disableCheckConstraintStatement.getConstraintName());
        }
        return new Sql[]{new UnparsedSql(((StringBuilder)object).toString(), new DatabaseObject[0])};
    }
}

