/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipBehavior;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;

public class PopoverBehavior
extends TooltipBehavior {
    private final IModel<String> body;

    public PopoverBehavior(IModel<String> label, IModel<String> body) {
        this(label, body, new PopoverConfig());
    }

    public PopoverBehavior(IModel<String> label, IModel<String> body, PopoverConfig config) {
        super(label, config);
        this.body = body;
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        tag.put("data-content", (CharSequence)this.newContent());
    }

    @Override
    public void detach(Component component) {
        super.detach(component);
        if (this.body != null) {
            this.body.detach();
        }
    }

    @Override
    protected String createRelAttribute() {
        return "popover";
    }

    protected String newContent() {
        return (String)this.body.getObject();
    }

    @Override
    protected CharSequence createInitializerScript(Component component, Config config) {
        return JQuery.$((Component)component).chain((CharSequence)"popover", config, new Config[0]).get();
    }
}

