/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.token;

import com.nimbusds.oauth2.sdk.dpop.verifiers.InvalidDPoPProofException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class OidcAccessTokenEndpointController
extends OAuth20AccessTokenEndpointController<OidcConfigurationContext> {
    public OidcAccessTokenEndpointController(OidcConfigurationContext oauthConfigurationContext, AuditableExecution accessTokenGrantAuditableRequestExtractor) {
        super((OAuth20ConfigurationContext)oauthConfigurationContext, accessTokenGrantAuditableRequestExtractor);
    }

    @PostMapping(value={"/oidc/accessToken", "/oidc/token", "/**/oidcAccessToken", "/**/oidcToken"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "oidcAccessToken") && !((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "oidcToken")) {
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"invalid_request", (String)"Invalid issuer");
        }
        return super.handleRequest(request, response);
    }

    @GetMapping(value={"/oidc/accessToken", "/oidc/token", "/**/oidcAccessToken", "/**/oidcToken"})
    public ModelAndView handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }

    @ExceptionHandler(value={InvalidDPoPProofException.class})
    public ModelAndView handleInvalidDPoPProofException(HttpServletResponse req, Exception ex) {
        return OAuth20Utils.writeError((HttpServletResponse)req, (String)"invalid_dpop_proof");
    }
}

