/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class OidcCallbackAuthorizeViewResolver
implements OAuth20CallbackAuthorizeViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCallbackAuthorizeViewResolver.class);
    private final ServicesManager servicesManager;
    private final OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder;
    private final OAuth20RequestParameterResolver oauthRequestParameterResolver;

    public ModelAndView resolve(WebContext context, ProfileManager manager, String url) {
        Set prompt = this.oauthRequestParameterResolver.resolveSupportedPromptValues(url);
        if (prompt.contains("none")) {
            Optional result = manager.getProfile();
            if (result.isPresent()) {
                LOGGER.trace("Redirecting to URL [{}] without prompting for login", (Object)url);
                return new ModelAndView((View)new RedirectView(url));
            }
            Optional originalRedirectUrl = this.oauthRequestParameterResolver.resolveRequestParameter(context, "redirect_uri");
            if (originalRedirectUrl.isEmpty()) {
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("error", "login_required");
                return new ModelAndView((View)new MappingJackson2JsonView(), model);
            }
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("error", "login_required");
            this.oauthRequestParameterResolver.resolveRequestParameter(context, "state").ifPresent(state -> parameters.put("state", (String)state));
            String clientId = this.oauthRequestParameterResolver.resolveRequestParameter(context, "client_id").orElse("");
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId);
            OAuth20ResponseModeTypes responseType = this.oauthRequestParameterResolver.resolveResponseModeType(context);
            String redirect = (String)FunctionUtils.doIf((boolean)OAuth20Utils.isResponseModeTypeFormPost((OAuthRegisteredService)registeredService, (OAuth20ResponseModeTypes)responseType), originalRedirectUrl::get, () -> OidcRequestSupport.getRedirectUrlWithError((String)originalRedirectUrl.get(), "login_required", context)).get();
            return (ModelAndView)FunctionUtils.doUnchecked(() -> {
                LOGGER.warn("Unable to detect authenticated user profile for prompt-less login attempts. Redirecting to URL [{}]", (Object)redirect);
                return this.authorizationModelAndViewBuilder.build(registeredService, responseType, redirect, (Map)parameters);
            });
        }
        if (prompt.contains("login")) {
            LOGGER.trace("Removing login prompt from URL [{}]", (Object)url);
            String newUrl = OidcRequestSupport.removeOidcPromptFromAuthorizationRequest(url, "login");
            LOGGER.trace("Redirecting to URL [{}]", (Object)newUrl);
            return new ModelAndView((View)new RedirectView(newUrl));
        }
        LOGGER.trace("Redirecting to URL [{}]", (Object)url);
        return new ModelAndView((View)new RedirectView(url));
    }

    @Generated
    public OidcCallbackAuthorizeViewResolver(ServicesManager servicesManager, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder, OAuth20RequestParameterResolver oauthRequestParameterResolver) {
        this.servicesManager = servicesManager;
        this.authorizationModelAndViewBuilder = authorizationModelAndViewBuilder;
        this.oauthRequestParameterResolver = oauthRequestParameterResolver;
    }
}

