/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceChainingAttributeReleasePolicy;
import org.apereo.cas.services.ServiceRegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcServiceRegistryListener
implements ServiceRegistryListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcServiceRegistryListener.class);
    private static final long serialVersionUID = -2492163812728091841L;
    private final OidcAttributeReleasePolicyFactory attributeReleasePolicyFactory;

    private static void addAttributeReleasePolicy(RegisteredServiceChainingAttributeReleasePolicy chain, BaseOidcScopeAttributeReleasePolicy policyToAdd, String givenScope, OidcRegisteredService registeredService) {
        OidcRegisteredServiceAttributeReleasePolicy oidcPolicy;
        LOGGER.debug("Mapped [{}] to attribute release policy [{}]", (Object)givenScope, (Object)policyToAdd.getClass().getSimpleName());
        RegisteredServiceAttributeReleasePolicy policy = registeredService.getAttributeReleasePolicy();
        ArrayList<OidcRegisteredServiceAttributeReleasePolicy> matchingPolicies = new ArrayList<OidcRegisteredServiceAttributeReleasePolicy>();
        if (policy instanceof RegisteredServiceChainingAttributeReleasePolicy) {
            RegisteredServiceChainingAttributeReleasePolicy chainedPolicy = (RegisteredServiceChainingAttributeReleasePolicy)policy;
            matchingPolicies.addAll(chainedPolicy.getPolicies().stream().filter(p -> p instanceof OidcRegisteredServiceAttributeReleasePolicy).map(OidcRegisteredServiceAttributeReleasePolicy.class::cast).filter(p -> p.getScopeType().equalsIgnoreCase(givenScope)).collect(Collectors.toList()));
        } else if (policy instanceof OidcRegisteredServiceAttributeReleasePolicy && (oidcPolicy = (OidcRegisteredServiceAttributeReleasePolicy)policy).getScopeType().equalsIgnoreCase(givenScope)) {
            matchingPolicies.add(oidcPolicy);
        }
        if (matchingPolicies.isEmpty()) {
            policyToAdd.setConsentPolicy(policy.getConsentPolicy());
            policyToAdd.setPrincipalAttributesRepository(policy.getPrincipalAttributesRepository());
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policyToAdd});
        } else {
            chain.addPolicies(matchingPolicies);
        }
    }

    public RegisteredService postLoad(RegisteredService registeredService) {
        if (registeredService instanceof OidcRegisteredService) {
            return this.reconcile((OidcRegisteredService)registeredService);
        }
        return registeredService;
    }

    protected RegisteredService reconcile(OidcRegisteredService oidcService) {
        boolean scopeFree;
        LOGGER.trace("Reconciling OpenId Connect scopes and claims for [{}]", (Object)oidcService.getServiceId());
        Set definedServiceScopes = oidcService.getScopes();
        if (definedServiceScopes.isEmpty()) {
            LOGGER.trace("Registered service [{}] does not define any scopes to control attribute release policies. CAS will allow the existing attribute release policies assigned to the service to operate without a scope.", (Object)oidcService.getServiceId());
            return oidcService;
        }
        Collection<OidcCustomScopeAttributeReleasePolicy> userScopes = this.attributeReleasePolicyFactory.getUserDefinedScopes();
        ArrayList<String> customClaims = new ArrayList<String>();
        ChainingAttributeReleasePolicy policyChain = new ChainingAttributeReleasePolicy();
        definedServiceScopes.forEach(givenScope -> {
            LOGGER.trace("Reviewing scope [{}] for [{}]", givenScope, (Object)oidcService.getServiceId());
            boolean userDefinedScope = Arrays.stream(OidcConstants.StandardScopes.values()).noneMatch(scope -> scope.getScope().trim().equalsIgnoreCase(givenScope.trim()));
            if (userDefinedScope) {
                LOGGER.debug("[{}] appears to be a user-defined scope and does not match any of the predefined standard scopes. Checking [{}] against user-defined scopes provided as [{}]", new Object[]{givenScope, givenScope, userScopes});
                userScopes.stream().filter(t -> t.getScopeName().equals(givenScope.trim())).findFirst().ifPresentOrElse(userPolicy -> OidcServiceRegistryListener.addAttributeReleasePolicy((RegisteredServiceChainingAttributeReleasePolicy)policyChain, (BaseOidcScopeAttributeReleasePolicy)userPolicy, givenScope, oidcService), () -> customClaims.add(givenScope.trim()));
            } else {
                OidcConstants.StandardScopes scope2 = OidcConstants.StandardScopes.valueOf((String)givenScope.trim().toUpperCase());
                switch (scope2) {
                    case EMAIL: 
                    case ADDRESS: 
                    case PROFILE: 
                    case PHONE: {
                        BaseOidcScopeAttributeReleasePolicy policyToAdd = this.attributeReleasePolicyFactory.get(scope2);
                        OidcServiceRegistryListener.addAttributeReleasePolicy((RegisteredServiceChainingAttributeReleasePolicy)policyChain, policyToAdd, givenScope, oidcService);
                        break;
                    }
                    case OPENID: {
                        LOGGER.debug("Scope [{}] is found for service [{}]", givenScope, (Object)oidcService.getId());
                        break;
                    }
                    case OFFLINE_ACCESS: {
                        LOGGER.debug("Given scope [{}], service [{}] is marked to generate refresh tokens", givenScope, (Object)oidcService.getId());
                        oidcService.setGenerateRefreshToken(true);
                    }
                }
            }
        });
        if (!customClaims.isEmpty()) {
            OidcCustomScopeAttributeReleasePolicy userPolicy = this.attributeReleasePolicyFactory.custom("custom", customClaims);
            OidcServiceRegistryListener.addAttributeReleasePolicy((RegisteredServiceChainingAttributeReleasePolicy)policyChain, (BaseOidcScopeAttributeReleasePolicy)userPolicy, userPolicy.getScopeName(), oidcService);
        }
        boolean bl = scopeFree = definedServiceScopes.isEmpty() || definedServiceScopes.size() == 1 && definedServiceScopes.contains(OidcConstants.StandardScopes.OPENID.getScope());
        if (scopeFree) {
            LOGGER.trace("Service definition [{}] will use the assigned attribute release policy without scopes", (Object)oidcService.getName());
            if (oidcService.getAttributeReleasePolicy() instanceof RegisteredServiceChainingAttributeReleasePolicy) {
                RegisteredServiceChainingAttributeReleasePolicy chain = (RegisteredServiceChainingAttributeReleasePolicy)oidcService.getAttributeReleasePolicy();
                policyChain.addPolicies(chain.getPolicies().toArray(new RegisteredServiceAttributeReleasePolicy[0]));
            } else {
                policyChain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{oidcService.getAttributeReleasePolicy()});
            }
        }
        if (policyChain.getPolicies().isEmpty()) {
            LOGGER.debug("No attribute release policy could be determined based on given scopes. No claims/attributes will be released to [{}]", (Object)oidcService.getServiceId());
            oidcService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
        } else if (policyChain.size() == 1) {
            oidcService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policyChain.getPolicies().get(0));
        } else {
            oidcService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policyChain);
        }
        LOGGER.trace("Scope/claim reconciliation for service [{}] resulted in the following attribute release policy [{}]", (Object)oidcService.getServiceId(), (Object)oidcService.getAttributeReleasePolicy());
        return oidcService;
    }

    @Generated
    public OidcServiceRegistryListener(OidcAttributeReleasePolicyFactory attributeReleasePolicyFactory) {
        this.attributeReleasePolicyFactory = attributeReleasePolicyFactory;
    }
}

