/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.rest;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.lib.search.OrderByClauseBuilder;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.rest.api.service.JAXRSService;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestClient
implements RestClient {
    private static final long serialVersionUID = 1523999867826481989L;
    protected static final Logger LOG = LoggerFactory.getLogger(BaseRestClient.class);

    public SyncopeService getSyncopeService() {
        return this.getService(SyncopeService.class);
    }

    protected <T> T getService(Class<T> serviceClass) {
        return SyncopeEnduserSession.get().getService(serviceClass);
    }

    protected <T> T getService(String etag, Class<T> serviceClass) {
        return SyncopeEnduserSession.get().getService(etag, serviceClass);
    }

    protected <T> void resetClient(Class<T> serviceClass) {
        SyncopeEnduserSession.get().resetClient(serviceClass);
    }

    public String toOrderBy(SortParam<String> sort) {
        OrderByClauseBuilder builder = SyncopeClient.getOrderByClauseBuilder();
        String property = (String)sort.getProperty();
        if (property.indexOf(35) != -1) {
            property = property.substring(property.indexOf(35) + 1);
        }
        if (sort.isAscending()) {
            builder.asc(property);
        } else {
            builder.desc(property);
        }
        return builder.build();
    }

    protected <E extends JAXRSService, T> T getObject(E service, URI location, Class<T> resultClass) {
        WebClient webClient = WebClient.fromClient((Client)WebClient.client(service));
        webClient.accept(new MediaType[]{SyncopeEnduserSession.get().getMediaType()}).to(location.toASCIIString(), false);
        return (T)webClient.header("X-Syncope-Domain", new Object[]{SyncopeEnduserSession.get().getDomain()}).header("Authorization", new Object[]{"Bearer " + SyncopeEnduserSession.get().getJWT()}).get(resultClass);
    }

    protected String getStatus(int httpStatus) {
        ExecStatus execStatus = ExecStatus.fromHttpStatus((int)httpStatus);
        return execStatus == null ? "UNKNOWN" : execStatus.name();
    }
}

