/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.yubico.u2f.U2F;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.web.U2FRegisteredDevicesEndpoint;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAccountCheckRegistrationAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAccountSaveRegistrationAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAuthenticationWebflowAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.u2f.web.flow.U2FMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.adaptors.u2f.web.flow.U2FMultifactorWebflowConfigurer;
import org.apereo.cas.adaptors.u2f.web.flow.U2FStartAuthenticationAction;
import org.apereo.cas.adaptors.u2f.web.flow.U2FStartRegistrationAction;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.U2F)
@AutoConfiguration
public class U2FWebflowConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices, module="u2f")
    @Configuration(value="U2fMultifactorTrustConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"u2fMultifactorWebflowConfigurer"})
    public static class U2FMultifactorTrustConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.u2f.trusted-device-enabled").isTrue().evenIfMissing();

        @ConditionalOnMissingBean(name={"u2fMultifactorTrustWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer u2fMultifactorTrustWebflowConfigurer(@Qualifier(value="u2fFlowRegistry") FlowDefinitionRegistry u2fFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="logoutFlowRegistry") FlowDefinitionRegistry logoutFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                U2FMultifactorTrustedDeviceWebflowConfigurer cfg = new U2FMultifactorTrustedDeviceWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, u2fFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
                cfg.setOrder(101);
                return cfg;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer u2fMultifactorTrustCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="u2fMultifactorTrustWebflowConfigurer") CasWebflowConfigurer u2fMultifactorTrustWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(u2fMultifactorTrustWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="U2FWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FWebflowActionConfiguration {
        @ConditionalOnMissingBean(name={"u2fAuthenticationWebflowAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action u2fAuthenticationWebflowAction(@Qualifier(value="u2fAuthenticationWebflowEventResolver") CasWebflowEventResolver u2fAuthenticationWebflowEventResolver) {
            return new U2FAuthenticationWebflowAction(u2fAuthenticationWebflowEventResolver);
        }

        @ConditionalOnMissingBean(name={"u2fStartAuthenticationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action u2fStartAuthenticationAction(CasConfigurationProperties casProperties, @Qualifier(value="u2fDeviceRepository") U2FDeviceRepository u2fDeviceRepository, @Qualifier(value="u2fService") U2F u2fService) {
            return new U2FStartAuthenticationAction(u2fService, casProperties.getServer().getName(), u2fDeviceRepository);
        }

        @ConditionalOnMissingBean(name={"u2fStartRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action u2fStartRegistrationAction(CasConfigurationProperties casProperties, @Qualifier(value="u2fDeviceRepository") U2FDeviceRepository u2fDeviceRepository, @Qualifier(value="u2fService") U2F u2fService) {
            return new U2FStartRegistrationAction(u2fService, casProperties.getServer().getName(), u2fDeviceRepository);
        }

        @ConditionalOnMissingBean(name={"u2fCheckAccountRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action u2fCheckAccountRegistrationAction(@Qualifier(value="u2fDeviceRepository") U2FDeviceRepository u2fDeviceRepository) {
            return new U2FAccountCheckRegistrationAction(u2fDeviceRepository);
        }

        @ConditionalOnMissingBean(name={"u2fSaveAccountRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action u2fSaveAccountRegistrationAction(@Qualifier(value="u2fDeviceRepository") U2FDeviceRepository u2fDeviceRepository, @Qualifier(value="u2fService") U2F u2fService) {
            return new U2FAccountSaveRegistrationAction(u2fService, u2fDeviceRepository);
        }
    }

    @Configuration(value="U2FWebflowEndpointConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FWebflowEndpointConfiguration {
        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public U2FRegisteredDevicesEndpoint u2fRegisteredDevicesEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="u2fDeviceRepository") ObjectProvider<U2FDeviceRepository> u2fDeviceRepository) {
            return new U2FRegisteredDevicesEndpoint(casProperties, u2fDeviceRepository);
        }
    }

    @Configuration(value="U2FWebflowExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FWebflowExecutionPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"u2fCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer u2fCasWebflowExecutionPlanConfigurer(@Qualifier(value="u2fMultifactorWebflowConfigurer") CasWebflowConfigurer u2fMultifactorWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(u2fMultifactorWebflowConfigurer);
        }
    }

    @Configuration(value="U2FWebflowEventConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FWebflowEventConfiguration {
        @ConditionalOnMissingBean(name={"u2fAuthenticationWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver u2fAuthenticationWebflowEventResolver(@Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new U2FAuthenticationWebflowEventResolver(casWebflowConfigurationContext);
        }
    }

    @Configuration(value="U2FWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FWebflowBaseConfiguration {
        @ConditionalOnMissingBean(name={"u2fMultifactorWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer u2fMultifactorWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="u2fFlowRegistry") FlowDefinitionRegistry u2fFlowRegistry, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            U2FMultifactorWebflowConfigurer cfg = new U2FMultifactorWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, u2fFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(100);
            return cfg;
        }
    }

    @Configuration(value="U2FWebflowRegistryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class U2FWebflowRegistryConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"u2fFlowRegistry"})
        public FlowDefinitionRegistry u2fFlowRegistry(ConfigurableApplicationContext applicationContext, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, "mfa-u2f");
            return builder.build();
        }
    }
}

