/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.web.flow;

import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.RegisterRequestData;
import com.yubico.u2f.data.messages.RegisterResponse;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.U2FMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class U2FAccountSaveRegistrationAction
extends AbstractMultifactorAuthenticationAction<U2FMultifactorAuthenticationProvider> {
    private final U2F u2f;
    private final U2FDeviceRepository u2FDeviceRepository;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Principal p = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal());
        String response = requestContext.getRequestParameters().get("tokenResponse");
        RegisterResponse registerResponse = RegisterResponse.fromJson((String)response);
        String regReqJson = this.u2FDeviceRepository.getDeviceRegistrationRequest(registerResponse.getRequestId(), p.getId());
        RegisterRequestData registerRequestData = RegisterRequestData.fromJson((String)regReqJson);
        DeviceRegistration registration = this.u2f.finishRegistration(registerRequestData, registerResponse);
        U2FDeviceRegistration record = U2FDeviceRegistration.builder().record((String)this.u2FDeviceRepository.getCipherExecutor().encode((Object)registration.toJsonWithAttestationCert())).username(p.getId()).build();
        this.u2FDeviceRepository.registerDevice(record);
        return this.success();
    }

    @Generated
    public U2FAccountSaveRegistrationAction(U2F u2f, U2FDeviceRepository u2FDeviceRepository) {
        this.u2f = u2f;
        this.u2FDeviceRepository = u2FDeviceRepository;
    }
}

