/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapURL;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.filter.FilterParseException;
import org.ldaptive.filter.FilterParser;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.referral.AbstractFollowReferralHandler;
import org.ldaptive.referral.DefaultReferralConnectionFactory;
import org.ldaptive.referral.ReferralConnectionFactory;
import org.ldaptive.transport.DefaultSearchOperationHandle;

public class FollowSearchReferralHandler
extends AbstractFollowReferralHandler<SearchRequest, SearchResponse>
implements SearchResultHandler {
    public FollowSearchReferralHandler() {
        this(10, 1, new DefaultReferralConnectionFactory());
    }

    public FollowSearchReferralHandler(ReferralConnectionFactory factory) {
        this(10, 1, factory);
    }

    public FollowSearchReferralHandler(int limit) {
        this(limit, 1, new DefaultReferralConnectionFactory());
    }

    public FollowSearchReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 1, factory);
    }

    private FollowSearchReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        super(limit, depth, factory);
    }

    @Override
    protected SearchRequest createReferralRequest(LdapURL url) {
        try {
            return (SearchRequest)((SearchRequest.Builder)SearchRequest.builder().controls(((SearchRequest)this.getRequest()).getControls())).scope(!url.isDefaultScope() ? url.getScope() : ((SearchRequest)this.getRequest()).getSearchScope()).dn(!url.isDefaultBaseDn() ? url.getBaseDn() : ((SearchRequest)this.getRequest()).getBaseDn()).filter(!url.isDefaultFilter() ? FilterParser.parse(url.getFilter()) : ((SearchRequest)this.getRequest()).getFilter()).sizeLimit(((SearchRequest)this.getRequest()).getSizeLimit()).timeLimit(((SearchRequest)this.getRequest()).getTimeLimit()).typesOnly(((SearchRequest)this.getRequest()).isTypesOnly()).returnAttributes(((SearchRequest)this.getRequest()).getReturnAttributes()).aliases(((SearchRequest)this.getRequest()).getDerefAliases()).binaryAttributes(((SearchRequest)this.getRequest()).getBinaryAttributes()).build();
        }
        catch (FilterParseException e) {
            throw new IllegalStateException("Could not parse filter in the LDAP URL '" + url.getFilter() + "'", e);
        }
    }

    protected SearchOperation createReferralOperation(ConnectionFactory factory) {
        DefaultSearchOperationHandle handle = (DefaultSearchOperationHandle)this.getHandle();
        SearchOperation op = new SearchOperation(factory);
        op.setResultHandlers(handle.getOnResult());
        op.setEntryHandlers(handle.getOnEntry());
        op.setReferenceHandlers(handle.getOnReference());
        op.setControlHandlers(handle.getOnControl());
        op.setExceptionHandler(handle.getOnException());
        op.setIntermediateResponseHandlers(handle.getOnIntermediate());
        op.setReferralHandlers(handle.getOnReferral());
        op.setUnsolicitedNotificationHandlers(handle.getOnUnsolicitedNotification());
        op.setSearchResultHandlers(new FollowSearchReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory()));
        return op;
    }
}

