/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.scim;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.syncope.core.logic.scim.SCIMFilterErrorHandler;
import org.apache.syncope.core.logic.scim.SCIMFilterLexer;
import org.apache.syncope.core.logic.scim.SCIMFilterParser;
import org.apache.syncope.core.logic.scim.SearchCondVisitor;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchCondConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SearchCondConverter.class);

    public static SearchCond convert(SearchCondVisitor visitor, String filter) {
        SCIMFilterParser parser = new SCIMFilterParser((TokenStream)new CommonTokenStream((TokenSource)new SCIMFilterLexer((CharStream)CharStreams.fromString((String)filter))));
        parser.setBuildParseTree(true);
        parser.setTrimParseTree(true);
        parser.setProfile(true);
        parser.removeErrorListeners();
        parser.setErrorHandler((ANTLRErrorStrategy)new SCIMFilterErrorHandler());
        try {
            return (SearchCond)visitor.visit((ParseTree)parser.scimFilter());
        }
        catch (Exception e) {
            LOG.error("Could not parse '{}'", (Object)filter, (Object)e);
            throw new BadRequestException(ErrorType.invalidFilter, "Could not parse '" + filter + "'");
        }
    }

    private SearchCondConverter() {
    }
}

