/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractPac4jAuthenticationHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.InitializableObject;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWrapperAuthenticationHandler<I extends Credential, C extends Credentials>
extends AbstractPac4jAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWrapperAuthenticationHandler.class);
    @NonNull
    protected ProfileCreator profileCreator = AuthenticatorProfileCreator.INSTANCE;

    protected AbstractWrapperAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, SessionStore sessionStore) {
        super(name, servicesManager, principalFactory, order, sessionStore);
    }

    protected static WebContext getWebContext() {
        return new JEEContext(HttpRequestUtils.getHttpServletRequestFromRequestAttributes(), HttpRequestUtils.getHttpServletResponseFromRequestAttributes());
    }

    public boolean supports(Credential credential) {
        return credential != null && this.getCasCredentialsType().isAssignableFrom(credential.getClass());
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws GeneralSecurityException {
        C credentials = this.convertToPac4jCredentials(credential);
        LOGGER.trace("Credentials converted to [{}]", credentials);
        try {
            Authenticator authenticator = this.getAuthenticator(credential);
            if (authenticator instanceof InitializableObject) {
                LOGGER.trace("Initializing authenticator [{}]", (Object)authenticator);
                ((InitializableObject)authenticator).init();
            }
            WebContext webContext = AbstractWrapperAuthenticationHandler.getWebContext();
            LOGGER.trace("Validating credentials [{}] using authenticator [{}]", credentials, (Object)authenticator);
            authenticator.validate(credentials, webContext, this.sessionStore);
            LOGGER.trace("Creating user profile result for [{}]", credentials);
            Optional profileResult = this.profileCreator.create(credentials, webContext, this.sessionStore);
            if (profileResult.isEmpty()) {
                throw new FailedLoginException("Unable to create common profile instance for credential " + credential);
            }
            CommonProfile profile = (CommonProfile)CommonProfile.class.cast(profileResult.get());
            LOGGER.debug("Authenticated profile: [{}]", (Object)profile);
            ClientCredential clientCredential = new ClientCredential(credentials, authenticator.getClass().getSimpleName());
            return this.createResult(clientCredential, (UserProfile)profile, null);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException("Failed to validate credentials: " + e.getMessage());
        }
    }

    protected abstract C convertToPac4jCredentials(I var1) throws GeneralSecurityException;

    protected abstract Class<I> getCasCredentialsType();

    protected abstract Authenticator getAuthenticator(Credential var1);

    @Generated
    public void setProfileCreator(@NonNull ProfileCreator profileCreator) {
        if (profileCreator == null) {
            throw new NullPointerException("profileCreator is marked non-null but is null");
        }
        this.profileCreator = profileCreator;
    }
}

