/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.info;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.info.JavaImplInfo;

public class PlatformInfo
implements BaseBean {
    private static final long serialVersionUID = -7941853999417673827L;
    private boolean selfRegAllowed;
    private boolean pwdResetAllowed;
    private boolean pwdResetRequiringSecurityQuestions;
    private final Set<String> connIdLocations = new HashSet<String>();
    private final List<String> anyTypes = new ArrayList<String>();
    private final List<String> userClasses = new ArrayList<String>();
    private final List<String> anyTypeClasses = new ArrayList<String>();
    private final List<String> resources = new ArrayList<String>();
    private final Set<String> entitlements = new HashSet<String>();
    private final Set<String> implementationTypes = new HashSet<String>();
    private final Set<JavaImplInfo> javaImplInfos = new HashSet<JavaImplInfo>();

    public boolean isSelfRegAllowed() {
        return this.selfRegAllowed;
    }

    public boolean isPwdResetAllowed() {
        return this.pwdResetAllowed;
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return this.pwdResetRequiringSecurityQuestions;
    }

    @JacksonXmlElementWrapper(localName="connIdLocations")
    @JacksonXmlProperty(localName="connIdLocation")
    public Set<String> getConnIdLocations() {
        return this.connIdLocations;
    }

    @JacksonXmlElementWrapper(localName="anyTypes")
    @JacksonXmlProperty(localName="anyType")
    public List<String> getAnyTypes() {
        return this.anyTypes;
    }

    @JacksonXmlElementWrapper(localName="userClasses")
    @JacksonXmlProperty(localName="userClass")
    public List<String> getUserClasses() {
        return this.userClasses;
    }

    @JacksonXmlElementWrapper(localName="anyTypeClasses")
    @JacksonXmlProperty(localName="anyTypeClass")
    public List<String> getAnyTypeClasses() {
        return this.anyTypeClasses;
    }

    @JacksonXmlElementWrapper(localName="resources")
    @JacksonXmlProperty(localName="resource")
    public List<String> getResources() {
        return this.resources;
    }

    @JacksonXmlElementWrapper(localName="entitlements")
    @JacksonXmlProperty(localName="entitlement")
    public Set<String> getEntitlements() {
        return this.entitlements;
    }

    @JacksonXmlElementWrapper(localName="implementationTypes")
    @JacksonXmlProperty(localName="implementationType")
    public Set<String> getImplementationTypes() {
        return this.implementationTypes;
    }

    @JsonIgnore
    public Optional<JavaImplInfo> getJavaImplInfo(String type) {
        return this.javaImplInfos.stream().filter(javaImplInfo -> javaImplInfo.getType().equals(type)).findFirst();
    }

    @JacksonXmlElementWrapper(localName="javaImplInfos")
    @JacksonXmlProperty(localName="javaImplInfo")
    public Set<JavaImplInfo> getJavaImplInfos() {
        return this.javaImplInfos;
    }

    public void setSelfRegAllowed(boolean selfRegAllowed) {
        this.selfRegAllowed = selfRegAllowed;
    }

    public void setPwdResetAllowed(boolean pwdResetAllowed) {
        this.pwdResetAllowed = pwdResetAllowed;
    }

    public void setPwdResetRequiringSecurityQuestions(boolean pwdResetRequiringSecurityQuestions) {
        this.pwdResetRequiringSecurityQuestions = pwdResetRequiringSecurityQuestions;
    }
}

