/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxWizardBuilder<T extends Serializable>
extends AbstractModalPanelBuilder<T> {
    private static final long serialVersionUID = 5241745929825564456L;
    protected static final Logger LOG = LoggerFactory.getLogger(AjaxWizardBuilder.class);
    protected AjaxWizard.Mode mode = AjaxWizard.Mode.CREATE;
    protected final List<Component> outerObjects = new ArrayList<Component>();

    public AjaxWizardBuilder(T defaultItem, PageReference pageRef) {
        super(defaultItem, pageRef);
    }

    public AjaxWizardBuilder<T> addOuterObject(Component ... childs) {
        this.outerObjects.addAll(List.of(childs));
        return this;
    }

    @Override
    public AjaxWizard<T> build(String id, int index, AjaxWizard.Mode mode) {
        AjaxWizard<T> wizard = this.build(id, mode);
        for (int i = 1; i < index; ++i) {
            wizard.getWizardModel().next();
        }
        return wizard;
    }

    public AjaxWizard<T> build(AjaxWizard.Mode mode) {
        return this.build("wizard", mode);
    }

    public AjaxWizard<T> build(String id, AjaxWizard.Mode mode) {
        this.mode = mode;
        Object modelObj = this.newModelObject();
        return new AjaxWizard<T>(id, (Serializable)modelObj, this.buildModelSteps(modelObj, new WizardModel()), mode, this.pageRef, (Serializable)modelObj, mode){
            private static final long serialVersionUID = 7770507663760640735L;
            final /* synthetic */ Serializable val$modelObj;
            final /* synthetic */ AjaxWizard.Mode val$mode;
            {
                this.val$modelObj = serializable;
                this.val$mode = mode2;
                super(id, item, model, mode, pageRef);
            }

            @Override
            protected void onCancelInternal() {
                AjaxWizardBuilder.this.onCancelInternal(this.val$modelObj);
            }

            @Override
            protected Pair<Serializable, Serializable> onApplyInternal(AjaxRequestTarget target) {
                Serializable payload;
                Serializable res = AjaxWizardBuilder.this.onApplyInternal(this.val$modelObj);
                switch (this.val$mode) {
                    case CREATE: {
                        payload = AjaxWizardBuilder.this.getCreateCustomPayloadEvent(res, target);
                        break;
                    }
                    case EDIT: 
                    case TEMPLATE: {
                        payload = AjaxWizardBuilder.this.getEditCustomPayloadEvent(res, target);
                        break;
                    }
                    default: {
                        payload = null;
                    }
                }
                return Pair.of(payload, (Object)res);
            }

            @Override
            protected long getMaxWaitTimeInSeconds() {
                return AjaxWizardBuilder.this.getMaxWaitTimeInSeconds();
            }

            @Override
            protected void sendError(Exception exception) {
                ((BaseSession)BaseSession.class.cast(Session.get())).onException(exception);
            }

            @Override
            protected void sendWarning(String message) {
                AjaxWizardBuilder.this.sendWarning(message);
            }

            @Override
            protected Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> future) {
                return AjaxWizardBuilder.this.execute(future);
            }
        }.setEventSink(this.eventSink).addOuterObject(this.outerObjects);
    }

    protected abstract WizardModel buildModelSteps(T var1, WizardModel var2);

    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        return null;
    }

    protected abstract long getMaxWaitTimeInSeconds();

    protected abstract void sendError(Exception var1);

    protected abstract void sendWarning(String var1);

    protected abstract Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> var1);

    protected Serializable getEditCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        return null;
    }
}

