/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.SubmitableModalPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizardMgtButtonBar;
import org.apache.syncope.client.ui.commons.wizards.exception.CaptchaNotMatchingException;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.Wizard;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxWizard<T extends Serializable>
extends Wizard
implements SubmitableModalPanel,
WizardModalPanel<T> {
    private static final long serialVersionUID = -1272120742876833520L;
    private final List<Component> outerObjects = new ArrayList<Component>();
    protected static final Logger LOG = LoggerFactory.getLogger(AjaxWizard.class);
    private T item;
    private final Mode mode;
    private IEventSink eventSink;
    private final PageReference pageRef;

    public AjaxWizard(String id, T item, WizardModel model, Mode mode, PageReference pageRef) {
        super(id);
        this.item = item;
        this.mode = mode;
        this.pageRef = pageRef;
        if (mode == Mode.READONLY) {
            model.setCancelVisible(false);
        }
        this.add(new Component[]{new ListView<Component>("outerObjectsRepeater", this.outerObjects){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }});
        this.setOutputMarkupId(true);
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        this.init((IWizardModel)model);
    }

    public final AjaxWizard<T> addOuterObject(List<Component> childs) {
        this.outerObjects.addAll(childs);
        return this;
    }

    public AjaxWizard<T> setEventSink(IEventSink eventSink) {
        this.eventSink = eventSink;
        return this;
    }

    protected void init(IWizardModel wizardModel) {
        super.init(wizardModel);
        this.getForm().remove("feedback");
        if (this.mode == Mode.READONLY) {
            Iterator iter = wizardModel.stepIterator();
            while (iter.hasNext()) {
                ((WizardStep)WizardStep.class.cast(iter.next())).setEnabled(false);
            }
        }
    }

    protected Component newButtonBar(String id) {
        return new AjaxWizardMgtButtonBar(id, this, this.mode);
    }

    protected abstract void onCancelInternal();

    protected abstract void sendError(Exception var1);

    protected abstract void sendWarning(String var1);

    protected abstract Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> var1);

    protected abstract Pair<Serializable, Serializable> onApplyInternal(AjaxRequestTarget var1);

    protected abstract long getMaxWaitTimeInSeconds();

    public final void onCancel() {
        AjaxRequestTarget target = RequestCycle.get().find(AjaxRequestTarget.class).orElse(null);
        try {
            this.onCancelInternal();
            if (this.eventSink == null) {
                this.send((IEventSink)this, Broadcast.BUBBLE, new NewItemCancelEvent<T>(this.item, target));
            } else {
                this.send(this.eventSink, Broadcast.EXACT, new NewItemCancelEvent<T>(this.item, target));
            }
        }
        catch (Exception e) {
            LOG.warn("Wizard error on cancel", (Throwable)e);
            this.sendError(e);
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    public final void onFinish() {
        AjaxRequestTarget target = RequestCycle.get().find(AjaxRequestTarget.class).orElse(null);
        try {
            Serializable res = this.onApply(target);
            if (this.eventSink == null) {
                this.send((IEventSink)this, Broadcast.BUBBLE, new NewItemFinishEvent<T>(this.item, target).setResult(res));
            } else {
                this.send(this.eventSink, Broadcast.EXACT, new NewItemFinishEvent<T>(this.item, target).setResult(res));
            }
        }
        catch (TimeoutException te) {
            LOG.warn("Operation took too long", (Throwable)te);
            if (this.eventSink == null) {
                this.send((IEventSink)this, Broadcast.BUBBLE, new NewItemCancelEvent<T>(this.item, target));
            } else {
                this.send(this.eventSink, Broadcast.EXACT, new NewItemCancelEvent<T>(this.item, target));
            }
            this.sendWarning(this.getString("timeout"));
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
        catch (CaptchaNotMatchingException ce) {
            LOG.error("Wizard error on finish: captcha not matching", (Throwable)ce);
            this.sendError((Exception)new WicketRuntimeException(this.getString("captcha_error")));
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("Wizard error on finish", (Throwable)e);
            this.sendError(e);
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    @Override
    public T getItem() {
        return this.item;
    }

    public AjaxWizard<T> setItem(T item) {
        this.item = item;
        return this;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.onApply(target);
        }
        catch (TimeoutException te) {
            LOG.warn("Operation took too long", (Throwable)te);
            this.send(this.eventSink, Broadcast.EXACT, new NewItemCancelEvent<T>(this.item, target));
            this.sendWarning(this.getString("timeout"));
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    @Override
    public void onError(AjaxRequestTarget target) {
        ((BaseWebPage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    private Serializable onApply(AjaxRequestTarget target) throws TimeoutException {
        try {
            Future<Pair<Serializable, Serializable>> executor = this.execute(new ApplyFuture(target));
            Pair<Serializable, Serializable> res = executor.get(this.getMaxWaitTimeInSeconds(), TimeUnit.SECONDS);
            if (res.getLeft() != null) {
                this.send((IEventSink)this.pageRef.getPage(), Broadcast.BUBBLE, (Serializable)res.getLeft());
            }
            return (Serializable)res.getRight();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof CaptchaNotMatchingException) {
                throw (CaptchaNotMatchingException)e.getCause();
            }
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    private class ApplyFuture
    implements Callable<Pair<Serializable, Serializable>>,
    Serializable {
        private static final long serialVersionUID = -4657123322652656848L;
        private final AjaxRequestTarget target;
        private final Application application;
        private final RequestCycle requestCycle;
        private final Session session;

        ApplyFuture(AjaxRequestTarget target) {
            this.target = target;
            this.application = Application.get();
            this.requestCycle = RequestCycle.get();
            this.session = Session.exists() ? Session.get() : null;
        }

        @Override
        public Pair<Serializable, Serializable> call() throws Exception {
            try {
                ThreadContext.setApplication((Application)this.application);
                ThreadContext.setRequestCycle((RequestCycle)this.requestCycle);
                ThreadContext.setSession((Session)this.session);
                Pair<Serializable, Serializable> pair = AjaxWizard.this.onApplyInternal(this.target);
                return pair;
            }
            finally {
                ThreadContext.detach();
            }
        }
    }

    public static class NewItemFinishEvent<T extends Serializable>
    extends NewItemEvent<T> {
        private static final String EVENT_DESCRIPTION = "finish";
        private Serializable result;

        public NewItemFinishEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }

        public NewItemFinishEvent<T> setResult(Serializable result) {
            this.result = result;
            return this;
        }

        public Serializable getResult() {
            return this.result;
        }
    }

    public static class NewItemCancelEvent<T extends Serializable>
    extends NewItemEvent<T> {
        private static final String EVENT_DESCRIPTION = "cancel";

        public NewItemCancelEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }
    }

    public static class EditItemActionEvent<T extends Serializable>
    extends NewItemActionEvent<T> {
        private static final String EVENT_DESCRIPTION = "edit";

        public EditItemActionEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        public EditItemActionEvent(T item, int index, AjaxRequestTarget target) {
            super(item, index, target);
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }
    }

    public static class NewItemActionEvent<T extends Serializable>
    extends NewItemEvent<T> {
        private static final String EVENT_DESCRIPTION = "new";
        private int index;

        public NewItemActionEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        public NewItemActionEvent(T item, int index, AjaxRequestTarget target) {
            super(item, target);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }
    }

    public static abstract class NewItemEvent<T extends Serializable> {
        private final T item;
        private IModel<String> titleModel;
        private final AjaxRequestTarget target;
        private WizardModalPanel<?> modalPanel;

        public NewItemEvent(T item, AjaxRequestTarget target) {
            this.item = item;
            this.target = target;
        }

        public T getItem() {
            return this.item;
        }

        public Optional<AjaxRequestTarget> getTarget() {
            return Optional.ofNullable(this.target);
        }

        public WizardModalPanel<?> getModalPanel() {
            return this.modalPanel;
        }

        public NewItemEvent<T> forceModalPanel(WizardModalPanel<?> modalPanel) {
            this.modalPanel = modalPanel;
            return this;
        }

        public IModel<String> getTitleModel() {
            return this.titleModel;
        }

        public NewItemEvent<T> setTitleModel(IModel<String> titleModel) {
            this.titleModel = titleModel;
            return this;
        }

        public abstract String getEventDescription();
    }

    public static enum Mode {
        CREATE,
        EDIT,
        TEMPLATE,
        READONLY,
        EDIT_APPROVAL;

    }
}

