/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.multitenant;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.multitenant.Node;
import org.apache.storm.scheduler.multitenant.NodePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedPool
extends NodePool {
    private static final Logger LOG = LoggerFactory.getLogger(IsolatedPool.class);
    private Map<String, Set<Node>> topologyIdToNodes = new HashMap<String, Set<Node>>();
    private HashMap<String, TopologyDetails> tds = new HashMap();
    private HashSet<String> isolated = new HashSet();
    private int maxNodes;
    private int usedNodes;

    public IsolatedPool(int maxNodes) {
        this.maxNodes = maxNodes;
        this.usedNodes = 0;
    }

    @Override
    public void addTopology(TopologyDetails td) {
        String topId = td.getId();
        LOG.debug("Adding in Topology {}", (Object)topId);
        SchedulerAssignment assignment = this.cluster.getAssignmentById(topId);
        HashSet<Node> assignedNodes = new HashSet<Node>();
        if (assignment != null) {
            for (WorkerSlot ws : assignment.getSlots()) {
                Node n = (Node)this.nodeIdToNode.get(ws.getNodeId());
                assignedNodes.add(n);
            }
        }
        this.usedNodes += assignedNodes.size();
        this.topologyIdToNodes.put(topId, assignedNodes);
        this.tds.put(topId, td);
        if (td.getConf().get("topology.isolate.machines") != null) {
            this.isolated.add(topId);
        }
    }

    @Override
    public boolean canAdd(TopologyDetails td) {
        String topId = td.getId();
        SchedulerAssignment assignment = this.cluster.getAssignmentById(topId);
        if (assignment != null) {
            for (WorkerSlot ws : assignment.getSlots()) {
                Node n = (Node)this.nodeIdToNode.get(ws.getNodeId());
                if (n.getRunningTopologies().size() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void scheduleAsNeeded(NodePool ... lesserPools) {
        for (String topId : this.topologyIdToNodes.keySet()) {
            Set<Node> found;
            TopologyDetails td = this.tds.get(topId);
            Set<Node> allNodes = this.topologyIdToNodes.get(topId);
            Number nodesRequested = (Number)td.getConf().get("topology.isolate.machines");
            Integer effectiveNodesRequested = null;
            if (nodesRequested != null) {
                effectiveNodesRequested = Math.min(td.getExecutors().size(), nodesRequested.intValue());
            }
            if (this.cluster.needsScheduling(td) || effectiveNodesRequested != null && allNodes.size() != effectiveNodesRequested.intValue()) {
                Node n;
                LOG.debug("Scheduling topology {}", (Object)topId);
                int slotsToUse = 0;
                slotsToUse = effectiveNodesRequested == null ? this.getNodesForNotIsolatedTop(td, allNodes, lesserPools) : this.getNodesForIsolatedTop(td, allNodes, lesserPools, effectiveNodesRequested);
                if (slotsToUse <= 0) continue;
                NodePool.RoundRobinSlotScheduler slotSched = new NodePool.RoundRobinSlotScheduler(td, slotsToUse, this.cluster);
                LOG.debug("Nodes sorted by free space {}", allNodes);
                do {
                    if ((n = this.findBestNode(allNodes)) != null) continue;
                    LOG.error("No nodes to use to assign topology {}", (Object)td.getName());
                    break;
                } while (slotSched.assignSlotTo(n));
            }
            int nc = (found = this.topologyIdToNodes.get(topId)) == null ? 0 : found.size();
            this.cluster.setStatus(topId, "Scheduled Isolated on " + nc + " Nodes");
        }
    }

    private Node findBestNode(Collection<Node> nodes) {
        Node ret = null;
        for (Node node : nodes) {
            if (ret == null) {
                if (node.totalSlotsFree() <= 0) continue;
                ret = node;
                continue;
            }
            if (node.totalSlotsFree() <= 0) continue;
            if (node.totalSlotsUsed() < ret.totalSlotsUsed()) {
                ret = node;
                continue;
            }
            if (node.totalSlotsUsed() != ret.totalSlotsUsed() || node.totalSlotsFree() <= ret.totalSlotsFree()) continue;
            ret = node;
        }
        return ret;
    }

    private int getNodesForIsolatedTop(TopologyDetails td, Set<Node> allNodes, NodePool[] lesserPools, int nodesRequested) {
        String topId = td.getId();
        LOG.debug("Topology {} is isolated", (Object)topId);
        int nodesFromUsAvailable = this.nodesAvailable();
        int nodesFromOthersAvailable = NodePool.nodesAvailable(lesserPools);
        int nodesUsed = this.topologyIdToNodes.get(topId).size();
        int nodesNeeded = nodesRequested - nodesUsed;
        LOG.debug("Nodes... requested {} used {} available from us {} avail from other {} needed {}", new Object[]{nodesRequested, nodesUsed, nodesFromUsAvailable, nodesFromOthersAvailable, nodesNeeded});
        if (nodesNeeded - nodesFromUsAvailable > this.maxNodes - this.usedNodes) {
            this.cluster.setStatus(topId, "Max Nodes(" + this.maxNodes + ") for this user would be exceeded. " + (nodesNeeded - nodesFromUsAvailable - (this.maxNodes - this.usedNodes)) + " more nodes needed to run topology.");
            return 0;
        }
        int nodesNeededFromOthers = Math.min(Math.min(this.maxNodes - this.usedNodes, nodesFromOthersAvailable), nodesNeeded);
        int nodesNeededFromUs = nodesNeeded - nodesNeededFromOthers;
        LOG.debug("Nodes... needed from us {} needed from others {}", (Object)nodesNeededFromUs, (Object)nodesNeededFromOthers);
        if (nodesNeededFromUs > nodesFromUsAvailable) {
            this.cluster.setStatus(topId, "Not Enough Nodes Available to Schedule Topology");
            return 0;
        }
        Collection<Node> found = NodePool.takeNodes(nodesNeededFromOthers, lesserPools);
        this.usedNodes += found.size();
        allNodes.addAll(found);
        Collection<Node> foundMore = this.takeNodes(nodesNeededFromUs);
        this.usedNodes += foundMore.size();
        allNodes.addAll(foundMore);
        int totalTasks = td.getExecutors().size();
        int origRequest = td.getNumWorkers();
        int slotsRequested = Math.min(totalTasks, origRequest);
        int slotsUsed = Node.countSlotsUsed(allNodes);
        int slotsFree = Node.countFreeSlotsAlive(allNodes);
        int slotsToUse = Math.min(slotsRequested - slotsUsed, slotsFree);
        if (slotsToUse <= 0) {
            if (origRequest > slotsUsed) {
                this.cluster.setStatus(topId, "Running with fewer slots than requested " + slotsUsed + "/" + origRequest + " on " + allNodes.size() + " node(s) with " + (slotsUsed + slotsFree) + " total slots");
            } else {
                this.cluster.setStatus(topId, "Node has partially crashed, if this situation persists rebalance the topology.");
            }
        }
        return slotsToUse;
    }

    private int getNodesForNotIsolatedTop(TopologyDetails td, Set<Node> allNodes, NodePool[] lesserPools) {
        String topId = td.getId();
        LOG.debug("Topology {} is not isolated", (Object)topId);
        int totalTasks = td.getExecutors().size();
        int origRequest = td.getNumWorkers();
        int slotsRequested = Math.min(totalTasks, origRequest);
        int slotsUsed = Node.countSlotsUsed(topId, allNodes);
        int slotsFree = Node.countFreeSlotsAlive(allNodes);
        int slotsAvailable = 0;
        if (slotsRequested > slotsFree) {
            slotsAvailable = NodePool.slotsAvailable(lesserPools);
        }
        int slotsToUse = Math.min(slotsRequested - slotsUsed, slotsFree + slotsAvailable);
        LOG.debug("Slots... requested {} used {} free {} available {} to be used {}", new Object[]{slotsRequested, slotsUsed, slotsFree, slotsAvailable, slotsToUse});
        if (slotsToUse <= 0) {
            this.cluster.setStatus(topId, "Not Enough Slots Available to Schedule Topology");
            return 0;
        }
        int slotsNeeded = slotsToUse - slotsFree;
        int numNewNodes = NodePool.getNodeCountIfSlotsWereTaken(slotsNeeded, lesserPools);
        LOG.debug("Nodes... new {} used {} max {}", new Object[]{numNewNodes, this.usedNodes, this.maxNodes});
        if (numNewNodes + this.usedNodes > this.maxNodes) {
            this.cluster.setStatus(topId, "Max Nodes(" + this.maxNodes + ") for this user would be exceeded. " + (numNewNodes - (this.maxNodes - this.usedNodes)) + " more nodes needed to run topology.");
            return 0;
        }
        Collection<Node> found = NodePool.takeNodesBySlot(slotsNeeded, lesserPools);
        this.usedNodes += found.size();
        allNodes.addAll(found);
        return slotsToUse;
    }

    @Override
    public Collection<Node> takeNodes(int nodesNeeded) {
        LOG.debug("Taking {} from {}", (Object)nodesNeeded, (Object)this);
        HashSet<Node> ret = new HashSet<Node>();
        for (Map.Entry<String, Set<Node>> entry : this.topologyIdToNodes.entrySet()) {
            if (this.isolated.contains(entry.getKey())) continue;
            Iterator<Node> it = entry.getValue().iterator();
            while (it.hasNext()) {
                if (nodesNeeded <= 0) {
                    return ret;
                }
                Node n = it.next();
                it.remove();
                n.freeAllSlots(this.cluster);
                ret.add(n);
                --nodesNeeded;
                --this.usedNodes;
            }
        }
        return ret;
    }

    @Override
    public int nodesAvailable() {
        int total = 0;
        for (Map.Entry<String, Set<Node>> entry : this.topologyIdToNodes.entrySet()) {
            if (this.isolated.contains(entry.getKey())) continue;
            total += entry.getValue().size();
        }
        return total;
    }

    @Override
    public int slotsAvailable() {
        int total = 0;
        for (Map.Entry<String, Set<Node>> entry : this.topologyIdToNodes.entrySet()) {
            if (this.isolated.contains(entry.getKey())) continue;
            total += Node.countTotalSlotsAlive((Collection<Node>)entry.getValue());
        }
        return total;
    }

    @Override
    public Collection<Node> takeNodesBySlots(int slotsNeeded) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Map.Entry<String, Set<Node>> entry : this.topologyIdToNodes.entrySet()) {
            if (this.isolated.contains(entry.getKey())) continue;
            Iterator<Node> it = entry.getValue().iterator();
            while (it.hasNext()) {
                Node n = it.next();
                if (!n.isAlive()) continue;
                it.remove();
                --this.usedNodes;
                n.freeAllSlots(this.cluster);
                ret.add(n);
                if ((slotsNeeded -= n.totalSlots()) > 0) continue;
                return ret;
            }
        }
        return ret;
    }

    @Override
    public NodePool.NodeAndSlotCounts getNodeAndSlotCountIfSlotsWereTaken(int slotsNeeded) {
        int nodesFound = 0;
        int slotsFound = 0;
        for (Map.Entry<String, Set<Node>> entry : this.topologyIdToNodes.entrySet()) {
            if (this.isolated.contains(entry.getKey())) continue;
            for (Node n : entry.getValue()) {
                if (!n.isAlive()) continue;
                ++nodesFound;
                int totalSlotsFree = n.totalSlots();
                slotsFound += totalSlotsFree;
                if ((slotsNeeded -= totalSlotsFree) > 0) continue;
                return new NodePool.NodeAndSlotCounts(nodesFound, slotsFound);
            }
        }
        return new NodePool.NodeAndSlotCounts(nodesFound, slotsFound);
    }

    public String toString() {
        return "IsolatedPool... ";
    }
}

