/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.oci;

import java.util.ArrayList;
import java.util.Map;

public class ImageManifest {
    private final int schemaVersion;
    private final String mediaType;
    private final Blob config;
    private final ArrayList<Blob> layers;
    private final Map<String, String> annotations;

    public ImageManifest() {
        this(0, null, null, null, null);
    }

    public ImageManifest(int schemaVersion, String mediaType, Blob config, ArrayList<Blob> layers, Map<String, String> annotations) {
        this.schemaVersion = schemaVersion;
        this.mediaType = mediaType;
        this.config = config;
        this.layers = layers;
        this.annotations = annotations;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Blob getConfig() {
        return this.config;
    }

    public ArrayList<Blob> getLayers() {
        return this.layers;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("schemaVersion: " + this.schemaVersion + "\n");
        sb.append("mediaType: " + this.mediaType + "\n");
        sb.append(this.config.toString());
        for (Blob b : this.layers) {
            sb.append(b.toString());
        }
        return sb.toString();
    }

    static class Blob {
        private final String mediaType;
        private final String digest;
        private final long size;
        private final ArrayList<String> urls;
        private final Map<String, String> annotations;

        Blob() {
            this(null, null, 0L, null, null);
        }

        Blob(String mediaType, String digest, long size, ArrayList<String> urls, Map<String, String> annotations) {
            this.mediaType = mediaType;
            this.digest = digest;
            this.size = size;
            this.urls = urls;
            this.annotations = annotations;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public String getDigest() {
            return this.digest;
        }

        public long getSize() {
            return this.size;
        }

        public ArrayList<String> getUrls() {
            return this.urls;
        }

        public Map<String, String> getAnnotations() {
            return this.annotations;
        }

        public String toString() {
            return "mediaType: " + this.mediaType + "\nsize: " + this.size + "\ndigest: " + this.digest + "\n";
        }
    }
}

