/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.storm.serialization.ITupleDeserializer;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.MessageId;
import org.apache.storm.tuple.TupleImpl;

public class KryoTupleDeserializer
implements ITupleDeserializer {
    private GeneralTopologyContext context;
    private KryoValuesDeserializer kryo;
    private SerializationFactory.IdDictionary ids;
    private Input kryoInput;

    public KryoTupleDeserializer(Map<String, Object> conf, GeneralTopologyContext context) {
        this.kryo = new KryoValuesDeserializer(conf);
        this.context = context;
        this.ids = new SerializationFactory.IdDictionary(context.getRawTopology());
        this.kryoInput = new Input(1);
    }

    @Override
    public TupleImpl deserialize(byte[] ser) {
        try {
            this.kryoInput.setBuffer(ser);
            int taskId = this.kryoInput.readInt(true);
            int streamId = this.kryoInput.readInt(true);
            String componentName = this.context.getComponentId(taskId);
            String streamName = this.ids.getStreamName(componentName, streamId);
            MessageId id = MessageId.deserialize(this.kryoInput);
            List<Object> values = this.kryo.deserializeFrom(this.kryoInput);
            return new TupleImpl(this.context, values, componentName, taskId, streamName, id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

