/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.BlowfishSerializer;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.storm.serialization.types.ListDelegateSerializer;
import org.apache.storm.shade.org.apache.commons.codec.DecoderException;
import org.apache.storm.shade.org.apache.commons.codec.binary.Hex;
import org.apache.storm.utils.ListDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlowfishTupleSerializer
extends Serializer<ListDelegate> {
    public static final String SECRET_KEY = "topology.tuple.serializer.blowfish.key";
    private static final Logger LOG = LoggerFactory.getLogger(BlowfishTupleSerializer.class);
    private BlowfishSerializer serializer;

    public BlowfishTupleSerializer(Kryo unused, Map<String, Object> topoConf) {
        try {
            byte[] bytes;
            String encryptionkey = (String)topoConf.get(SECRET_KEY);
            LOG.debug("Blowfish serializer being constructed ...");
            if (encryptionkey != null) {
                bytes = Hex.decodeHex((char[])encryptionkey.toCharArray());
            } else {
                String payload = (String)topoConf.get("storm.zookeeper.topology.auth.payload");
                if (payload != null) {
                    LOG.debug("{} is not present. Use {} as Blowfish encryption key", (Object)SECRET_KEY, (Object)"storm.zookeeper.topology.auth.payload");
                    bytes = payload.getBytes();
                } else {
                    throw new RuntimeException("Blowfish encryption key not specified");
                }
            }
            this.serializer = new BlowfishSerializer((Serializer)new ListDelegateSerializer(), bytes);
        }
        catch (DecoderException ex) {
            throw new RuntimeException("Blowfish encryption key invalid", ex);
        }
    }

    public static void main(String[] args) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("Blowfish");
            kgen.init(256);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            String keyString = new String(Hex.encodeHex((byte[])raw));
            System.out.println("storm -c topology.tuple.serializer.blowfish.key=" + keyString + " -c topology.tuple.serializer=" + BlowfishTupleSerializer.class.getName() + " ...");
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
    }

    public void write(Kryo kryo, Output output, ListDelegate object) {
        kryo.writeObject(output, (Object)object, (Serializer)this.serializer);
    }

    public ListDelegate read(Kryo kryo, Input input, Class<? extends ListDelegate> type) {
        return (ListDelegate)kryo.readObject(input, ListDelegate.class, (Serializer)this.serializer);
    }
}

