/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.shade.com.google.common.collect.ArrayListMultimap;
import org.apache.storm.shade.com.google.common.collect.HashBasedTable;
import org.apache.storm.shade.com.google.common.collect.Multimap;
import org.apache.storm.shade.com.google.common.collect.Table;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.shade.org.jgrapht.graph.DirectedSubgraph;
import org.apache.storm.shade.org.jgrapht.traverse.TopologicalOrderIterator;
import org.apache.storm.streams.Edge;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.PartitionNode;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.RefCountedTuple;
import org.apache.storm.streams.SinkNode;
import org.apache.storm.streams.StreamUtil;
import org.apache.storm.streams.WindowNode;
import org.apache.storm.streams.processors.ChainedProcessorContext;
import org.apache.storm.streams.processors.EmittingProcessorContext;
import org.apache.storm.streams.processors.ForwardingProcessorContext;
import org.apache.storm.streams.processors.Processor;
import org.apache.storm.streams.processors.ProcessorContext;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessorBoltDelegate
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorBoltDelegate.class);
    private final String id;
    private final DirectedGraph<Node, Edge> graph;
    private final List<ProcessorNode> nodes;
    private final List<ProcessorNode> outgoingProcessors = new ArrayList<ProcessorNode>();
    private final Set<EmittingProcessorContext> emittingProcessorContexts = new HashSet<EmittingProcessorContext>();
    private final Table<ProcessorNode, String, Integer> punctuationState = HashBasedTable.create();
    private final Map<String, Integer> streamToInputTaskCount = new HashMap<String, Integer>();
    private Map<String, Object> topoConf;
    private TopologyContext topologyContext;
    private OutputCollector outputCollector;
    private Multimap<String, ProcessorNode> streamToInitialProcessors;
    private String timestampField;

    ProcessorBoltDelegate(String id, DirectedGraph<Node, Edge> graph, List<ProcessorNode> nodes) {
        this.id = id;
        this.graph = graph;
        this.nodes = new ArrayList<ProcessorNode>(nodes);
    }

    String getId() {
        return this.id;
    }

    void addNodes(Collection<ProcessorNode> nodes) {
        this.nodes.addAll(nodes);
    }

    List<ProcessorNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.topoConf = topoConf;
        this.topologyContext = context;
        this.outputCollector = collector;
        DirectedSubgraph subgraph = new DirectedSubgraph(this.graph, new HashSet<ProcessorNode>(this.nodes), null);
        TopologicalOrderIterator it = new TopologicalOrderIterator((DirectedGraph)subgraph);
        while (it.hasNext()) {
            ProcessorContext processorContext;
            Node node = (Node)it.next();
            if (!(node instanceof ProcessorNode)) {
                throw new IllegalStateException("Not a processor node " + String.valueOf(node));
            }
            ProcessorNode processorNode = (ProcessorNode)node;
            List<ProcessorNode> children = StreamUtil.getChildren((DirectedGraph<Node, Edge>)subgraph, processorNode);
            if (children.isEmpty()) {
                processorContext = this.createEmittingContext(processorNode);
            } else {
                ArrayListMultimap streamToChildren = ArrayListMultimap.create();
                for (ProcessorNode child : children) {
                    for (String stream : child.getParentStreams(processorNode)) {
                        streamToChildren.put((Object)stream, (Object)child);
                    }
                }
                ForwardingProcessorContext forwardingContext = new ForwardingProcessorContext(processorNode, (Multimap<String, ProcessorNode>)streamToChildren);
                processorContext = this.hasOutgoingChild(processorNode, new HashSet<ProcessorNode>(children)) ? new ChainedProcessorContext(processorNode, forwardingContext, this.createEmittingContext(processorNode)) : forwardingContext;
            }
            processorNode.initProcessorContext(processorContext);
        }
        if (this.timestampField != null) {
            for (EmittingProcessorContext<Object> emittingProcessorContext : this.emittingProcessorContexts) {
                emittingProcessorContext.setTimestampField(this.timestampField);
            }
        }
        for (String string : this.streamToInitialProcessors.keySet()) {
            this.streamToInputTaskCount.put(string, this.getStreamInputTaskCount(context, string));
        }
    }

    void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (ProcessorNode node : this.nodes) {
            for (String stream : node.getOutputStreams()) {
                if (this.timestampField == null) {
                    declarer.declareStream(stream, node.getOutputFields());
                } else {
                    ArrayList<String> fields = new ArrayList<String>();
                    fields.addAll(node.getOutputFields().toList());
                    fields.add(this.timestampField);
                    declarer.declareStream(stream, new Fields(fields));
                }
                declarer.declareStream(StreamUtil.getPunctuationStream(stream), StreamUtil.getPunctuationFields());
            }
        }
    }

    void setAnchor(RefCountedTuple tuple) {
        for (EmittingProcessorContext ctx : this.emittingProcessorContexts) {
            ctx.setAnchor(tuple);
        }
    }

    Pair<Object, String> getValueAndStream(Tuple input) {
        Object stream;
        Pair<Object, Object> value;
        if (input.getSourceComponent().startsWith("spout")) {
            value = input;
            stream = input.getSourceGlobalStreamId().get_componentId() + input.getSourceGlobalStreamId().get_streamId();
        } else if (this.isPair(input)) {
            value = Pair.of(input.getValue(0), input.getValue(1));
            stream = input.getSourceStreamId();
        } else {
            value = input.getValue(0);
            stream = input.getSourceStreamId();
        }
        return Pair.of(value, stream);
    }

    void processAndAck(Tuple input) {
        RefCountedTuple refCountedTuple = new RefCountedTuple(input);
        this.setAnchor(refCountedTuple);
        if (this.isEventTimestamp()) {
            this.setEventTimestamp(input.getLongByField(this.getTimestampField()));
        }
        Pair<Object, String> valueAndStream = this.getValueAndStream(input);
        this.process(valueAndStream.getFirst(), valueAndStream.getSecond());
        this.ack(refCountedTuple);
    }

    void process(Object value, String sourceStreamId) {
        LOG.debug("Process value {}, sourceStreamId {}", value, (Object)sourceStreamId);
        if (StreamUtil.isPunctuation(value)) {
            this.punctuateInitialProcessors(sourceStreamId);
        } else {
            this.executeInitialProcessors(value, sourceStreamId);
        }
    }

    private void punctuateInitialProcessors(String punctuationStreamId) {
        String sourceStreamId = StreamUtil.getSourceStream(punctuationStreamId);
        Collection initialProcessors = this.streamToInitialProcessors.get((Object)sourceStreamId);
        for (ProcessorNode processorNode : initialProcessors) {
            if (!this.shouldPunctuate(processorNode, sourceStreamId)) continue;
            processorNode.getProcessor().punctuate(null);
            this.clearPunctuationState(processorNode);
        }
    }

    private void executeInitialProcessors(Object value, String sourceStreamId) {
        Collection initialProcessors = this.streamToInitialProcessors.get((Object)sourceStreamId);
        for (ProcessorNode processorNode : initialProcessors) {
            Processor<?> processor = processorNode.getProcessor();
            processor.execute(value, sourceStreamId);
        }
    }

    void setStreamToInitialProcessors(Multimap<String, ProcessorNode> streamToInitialProcessors) {
        this.streamToInitialProcessors = streamToInitialProcessors;
    }

    void addStreamToInitialProcessors(Multimap<String, ProcessorNode> streamToInitialProcessors) {
        this.streamToInitialProcessors.putAll(streamToInitialProcessors);
    }

    Set<String> getInitialStreams() {
        return this.streamToInitialProcessors.keySet();
    }

    boolean isEventTimestamp() {
        return this.timestampField != null;
    }

    void setEventTimestamp(long timestamp) {
        for (EmittingProcessorContext ctx : this.emittingProcessorContexts) {
            ctx.setEventTimestamp(timestamp);
        }
    }

    private String getTimestampField() {
        return this.timestampField;
    }

    void setTimestampField(String fieldName) {
        this.timestampField = fieldName;
    }

    private void ack(RefCountedTuple tuple) {
        if (tuple.shouldAck()) {
            LOG.debug("ACKing tuple {}", (Object)tuple);
            this.outputCollector.ack(tuple.tuple());
            tuple.setAcked();
        }
    }

    private ProcessorContext createEmittingContext(ProcessorNode processorNode) {
        ArrayList emittingContexts = new ArrayList();
        for (String stream : processorNode.getOutputStreams()) {
            EmittingProcessorContext emittingContext = new EmittingProcessorContext(processorNode, this.outputCollector, stream);
            emittingContexts.add(emittingContext);
        }
        this.emittingProcessorContexts.addAll(emittingContexts);
        this.outgoingProcessors.add(processorNode);
        return new ChainedProcessorContext(processorNode, emittingContexts);
    }

    private boolean hasOutgoingChild(ProcessorNode processorNode, Set<ProcessorNode> boltChildren) {
        for (Node child : this.getChildNodes(processorNode)) {
            if ((!(child instanceof ProcessorNode) || boltChildren.contains(child)) && !(child instanceof SinkNode)) continue;
            return true;
        }
        return false;
    }

    private Set<Node> getChildNodes(Node node) {
        HashSet<Node> children = new HashSet<Node>();
        for (Node child : StreamUtil.getChildren(this.graph, node)) {
            if (child instanceof WindowNode || child instanceof PartitionNode) {
                children.addAll(this.getChildNodes(child));
                continue;
            }
            children.add(child);
        }
        return children;
    }

    private boolean shouldPunctuate(ProcessorNode processorNode, String sourceStreamId) {
        if (!processorNode.getWindowedParentStreams().isEmpty()) {
            this.updateCount(processorNode, sourceStreamId);
            if (this.punctuationState.row((Object)processorNode).size() != processorNode.getWindowedParentStreams().size()) {
                return false;
            }
            Set receivedStreams = this.punctuationState.row((Object)processorNode).keySet();
            if (!receivedStreams.equals(processorNode.getWindowedParentStreams())) {
                throw new IllegalStateException("Received punctuation from streams " + String.valueOf(receivedStreams) + " expected " + String.valueOf(processorNode.getWindowedParentStreams()));
            }
            for (String receivedStream : receivedStreams) {
                Integer expected = this.streamToInputTaskCount.get(receivedStream);
                if (expected == null) {
                    throw new IllegalStateException("Punctuation received on unexpected stream '" + receivedStream + "' for which input task count is not set.");
                }
                if ((Integer)this.punctuationState.get((Object)processorNode, (Object)receivedStream) >= this.streamToInputTaskCount.get(receivedStream)) continue;
                return false;
            }
        }
        return true;
    }

    private void updateCount(ProcessorNode processorNode, String sourceStreamId) {
        Integer count = (Integer)this.punctuationState.get((Object)processorNode, (Object)sourceStreamId);
        if (count == null) {
            this.punctuationState.put((Object)processorNode, (Object)sourceStreamId, (Object)1);
        } else {
            this.punctuationState.put((Object)processorNode, (Object)sourceStreamId, (Object)(count + 1));
        }
    }

    private void clearPunctuationState(ProcessorNode processorNode) {
        Map state;
        if (!this.punctuationState.isEmpty() && !(state = this.punctuationState.row((Object)processorNode)).isEmpty()) {
            state.clear();
        }
    }

    private boolean isPair(Tuple input) {
        return input.size() == (this.timestampField == null ? 2 : 3);
    }

    private int getStreamInputTaskCount(TopologyContext context, String stream) {
        int count = 0;
        for (GlobalStreamId inputStream : context.getThisSources().keySet()) {
            if (!stream.equals(this.getStreamId(inputStream))) continue;
            count += context.getComponentTasks(inputStream.get_componentId()).size();
        }
        return count;
    }

    private String getStreamId(GlobalStreamId globalStreamId) {
        if (globalStreamId.get_componentId().startsWith("spout")) {
            return globalStreamId.get_componentId() + globalStreamId.get_streamId();
        }
        return globalStreamId.get_streamId();
    }
}

