/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceUtils.class);
    @SuppressFBWarnings(value={"DM_EXIT"})
    public static final Consumer<Integer> SYSTEM_EXIT = code -> {
        String msg = "Exiting JVM with code {}";
        if (code == 0) {
            LOG.info(msg, code);
        } else {
            LOG.error(msg, code);
        }
        System.exit(code);
    };
    public static final Consumer<Integer> LOG_ONLY = code -> {
        if (code != 0) {
            LOG.error("Fatal error, JVM should exit with code {}. Actually System.exit is disabled", code);
        } else {
            LOG.info("JVM should exit with code {}. Actually System.exit is disabled", code);
        }
    };
    private static volatile Consumer<Integer> systemExitProcedure = SYSTEM_EXIT;

    private ServiceUtils() {
    }

    public static void setSystemExitProcedure(Consumer<Integer> systemExitProcedure) {
        Objects.requireNonNull(systemExitProcedure);
        ServiceUtils.systemExitProcedure = systemExitProcedure;
    }

    public static void requestSystemExit(int code) {
        systemExitProcedure.accept(code);
    }
}

