/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.utils.ShellCommandRunnerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologySpoutLag {
    private static final String SPOUT_ID = "spoutId";
    private static final String SPOUT_TYPE = "spoutType";
    private static final String SPOUT_LAG_RESULT = "spoutLagResult";
    private static final String ERROR_INFO = "errorInfo";
    private static final String CONFIG_KEY_PREFIX = "config.";
    private static final String TOPICS_CONFIG = "config.topics";
    private static final String GROUPID_CONFIG = "config.groupid";
    private static final String BOOTSTRAP_CONFIG = "config.bootstrap.servers";
    private static final String SECURITY_PROTOCOL_CONFIG = "config.security.protocol";
    private static final Set<String> ALL_CONFIGS = new HashSet<String>(Arrays.asList("config.topics", "config.groupid", "config.bootstrap.servers", "config.security.protocol"));
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologySpoutLag.class);

    public static Map<String, Map<String, Object>> lag(StormTopology stormTopology, Map<String, Object> topologyConf) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Map spouts = stormTopology.get_spouts();
        for (Map.Entry spout : spouts.entrySet()) {
            try {
                SpoutSpec spoutSpec = (SpoutSpec)spout.getValue();
                TopologySpoutLag.addLagResultForKafkaSpout(result, (String)spout.getKey(), spoutSpec);
            }
            catch (Exception e) {
                LOGGER.warn("Exception thrown while getting lag for spout id: " + (String)spout.getKey());
                LOGGER.warn("Exception message:" + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private static List<String> getCommandLineOptionsForNewKafkaSpout(Map<String, Object> jsonConf) {
        LOGGER.debug("json configuration: {}", jsonConf);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-t");
        commands.add((String)jsonConf.get(TOPICS_CONFIG));
        commands.add("-g");
        commands.add((String)jsonConf.get(GROUPID_CONFIG));
        commands.add("-b");
        commands.add((String)jsonConf.get(BOOTSTRAP_CONFIG));
        String securityProtocol = (String)jsonConf.get(SECURITY_PROTOCOL_CONFIG);
        if (!Strings.isNullOrEmpty((String)securityProtocol)) {
            commands.add("-s");
            commands.add(securityProtocol);
        }
        return commands;
    }

    private static File createExtraPropertiesFile(Map<String, Object> jsonConf) {
        File file = null;
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        for (Map.Entry<String, Object> conf : jsonConf.entrySet()) {
            if (!conf.getKey().startsWith(CONFIG_KEY_PREFIX) || ALL_CONFIGS.contains(conf.getKey())) continue;
            extraProperties.put(conf.getKey().substring(CONFIG_KEY_PREFIX.length()), conf.getValue().toString());
        }
        if (!extraProperties.isEmpty()) {
            try {
                file = Files.createTempFile("kafka-consumer-extra", "props", new FileAttribute[0]).toFile();
                file.deleteOnExit();
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)extraProperties);
                try (FileOutputStream fos = new FileOutputStream(file);){
                    properties.store(fos, "Kafka consumer extra properties");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    private static void addLagResultForKafkaSpout(Map<String, Map<String, Object>> finalResult, String spoutId, SpoutSpec spoutSpec) throws IOException {
        ComponentCommon componentCommon = spoutSpec.get_common();
        String json = componentCommon.get_json_conf();
        if (!Strings.isNullOrEmpty((String)json)) {
            Map jsonMap = null;
            try {
                jsonMap = (Map)JSONValue.parseWithException((String)json);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            if (jsonMap.containsKey(TOPICS_CONFIG) && jsonMap.containsKey(GROUPID_CONFIG) && jsonMap.containsKey(BOOTSTRAP_CONFIG)) {
                finalResult.put(spoutId, TopologySpoutLag.getLagResultForNewKafkaSpout(spoutId, spoutSpec));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> getLagResultForKafka(String spoutId, SpoutSpec spoutSpec) throws IOException {
        ComponentCommon componentCommon = spoutSpec.get_common();
        String json = componentCommon.get_json_conf();
        Map result = null;
        String errorMsg = "Make sure Kafka spout version is latest and " + TOPICS_CONFIG + ", " + GROUPID_CONFIG + " & " + BOOTSTRAP_CONFIG + " are not null for newer versions of Kafka spout.";
        if (!Strings.isNullOrEmpty((String)json)) {
            ArrayList<Object> commands = new ArrayList<Object>();
            Object stormHomeDir = System.getenv("STORM_BASE_DIR");
            if (stormHomeDir != null && !((String)stormHomeDir).endsWith("/")) {
                stormHomeDir = (String)stormHomeDir + File.separator;
            }
            commands.add(stormHomeDir != null ? (String)stormHomeDir + "bin" + File.separator + "storm-kafka-monitor" : "storm-kafka-monitor");
            Map jsonMap = null;
            try {
                jsonMap = (Map)JSONValue.parseWithException((String)json);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            commands.addAll(TopologySpoutLag.getCommandLineOptionsForNewKafkaSpout(jsonMap));
            File extraPropertiesFile = TopologySpoutLag.createExtraPropertiesFile(jsonMap);
            if (extraPropertiesFile != null) {
                commands.add("-c");
                commands.add(extraPropertiesFile.getAbsolutePath());
            }
            LOGGER.debug("Command to run: {}", commands);
            if (!commands.contains(null)) {
                try {
                    String resultFromMonitor = new ShellCommandRunnerImpl().execCommand(commands.toArray(new String[0]));
                    try {
                        result = (Map)JSONValue.parseWithException((String)resultFromMonitor);
                    }
                    catch (ParseException e) {
                        LOGGER.debug("JSON parsing failed, assuming message as error message: {}", (Object)resultFromMonitor);
                        errorMsg = resultFromMonitor;
                    }
                }
                finally {
                    if (extraPropertiesFile != null) {
                        extraPropertiesFile.delete();
                    }
                }
            }
        }
        HashMap<String, Object> kafkaSpoutLagInfo = new HashMap<String, Object>();
        kafkaSpoutLagInfo.put(SPOUT_ID, spoutId);
        kafkaSpoutLagInfo.put(SPOUT_TYPE, "KAFKA");
        if (result != null) {
            kafkaSpoutLagInfo.put(SPOUT_LAG_RESULT, result);
        } else {
            kafkaSpoutLagInfo.put(ERROR_INFO, errorMsg);
        }
        return kafkaSpoutLagInfo;
    }

    private static Map<String, Object> getLagResultForNewKafkaSpout(String spoutId, SpoutSpec spoutSpec) throws IOException {
        return TopologySpoutLag.getLagResultForKafka(spoutId, spoutSpec);
    }
}

