/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.impl.injectors.SlingObjectInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ResourceResolverInjectorTest {
    private SlingObjectInjector injector = new SlingObjectInjector();
    @Mock
    private AnnotatedElement element;
    @Mock
    private DisposalCallbackRegistry registry;

    ResourceResolverInjectorTest() {
    }

    @Test
    void testFromResource() {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        ResourceResolver resourceResolver = (ResourceResolver)Mockito.mock(ResourceResolver.class);
        Mockito.when((Object)resource.getResourceResolver()).thenReturn((Object)resourceResolver);
        Object result = this.injector.getValue((Object)resource, "resourceResolver", ResourceResolver.class, this.element, this.registry);
        Assertions.assertEquals((Object)resourceResolver, (Object)result);
    }

    @Test
    void testFromJakartaRequest() {
        SlingJakartaHttpServletRequest jakartaRequest = (SlingJakartaHttpServletRequest)Mockito.mock(SlingJakartaHttpServletRequest.class);
        ResourceResolver resourceResolver = (ResourceResolver)Mockito.mock(ResourceResolver.class);
        Mockito.when((Object)jakartaRequest.getResourceResolver()).thenReturn((Object)resourceResolver);
        Object result = this.injector.getValue((Object)jakartaRequest, "resourceResolver", ResourceResolver.class, this.element, this.registry);
        Assertions.assertEquals((Object)resourceResolver, (Object)result);
    }

    @Deprecated
    @Test
    void testFromJavaxRequest() {
        SlingHttpServletRequest javaxRequest = (SlingHttpServletRequest)Mockito.mock(SlingHttpServletRequest.class);
        ResourceResolver resourceResolver = (ResourceResolver)Mockito.mock(ResourceResolver.class);
        Mockito.when((Object)javaxRequest.getResourceResolver()).thenReturn((Object)resourceResolver);
        Object result = this.injector.getValue((Object)javaxRequest, "resourceResolver", ResourceResolver.class, this.element, this.registry);
        Assertions.assertEquals((Object)resourceResolver, (Object)result);
    }

    @Test
    void testFromSomethingElse() {
        SlingJakartaHttpServletResponse response = (SlingJakartaHttpServletResponse)Mockito.mock(SlingJakartaHttpServletResponse.class);
        Object result = this.injector.getValue((Object)response, "resourceResolver", ResourceResolver.class, this.element, this.registry);
        Assertions.assertNull((Object)result);
    }
}

