/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit;

import org.apache.sling.junit.SlingTestContext;

public class SlingTestContextProvider {
    private static final ThreadLocal<SlingTestContext> threadLocal = new ThreadLocal();

    public static SlingTestContext getContext() {
        SlingTestContext result = threadLocal.get();
        if (result == null) {
            throw new IllegalStateException("Null context, createContext() not called?");
        }
        return result;
    }

    public static SlingTestContext createContext() {
        threadLocal.set(new SlingTestContext());
        return SlingTestContextProvider.getContext();
    }

    public static void deleteContext() {
        threadLocal.set(null);
    }

    public static boolean hasContext() {
        return threadLocal.get() != null;
    }
}

