/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.sling.feature.cpconverter.accesscontrol.AccessControlEntry;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.handlers.AbstractPolicyEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractPolicyParser;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RepPolicyEntryHandler
extends AbstractPolicyEntryHandler {
    public RepPolicyEntryHandler() {
        this("/jcr_root(.*/)_rep_policy.xml");
    }

    RepPolicyEntryHandler(@NotNull String regex) {
        super(regex);
    }

    @Override
    @NotNull
    AbstractPolicyParser createPolicyParser(@NotNull RepoPath repositoryPath, @NotNull AclManager aclManager, @NotNull TransformerHandler handler) {
        return new RepPolicyParser(repositoryPath, aclManager, handler);
    }

    static final class RepPolicyParser
    extends AbstractPolicyParser {
        private static final String REP_ACL = "rep:ACL";
        private static final String REP_GRANT_ACE = "rep:GrantACE";
        private static final String REP_DENY_ACE = "rep:DenyACE";
        private static final Map<String, Boolean> operations = new HashMap<String, Boolean>();
        private final LinkedList<AccessControlEntry> entries = new LinkedList();
        private boolean processCurrentAce = false;

        public RepPolicyParser(RepoPath repositoryPath, AclManager aclManager, TransformerHandler handler) {
            super(REP_ACL, repositoryPath, aclManager, handler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.onRepAclNode) {
                String primaryType = attributes.getValue("jcr:primaryType");
                if (RepPolicyParser.isAccessControlEntry(primaryType)) {
                    String principalName = attributes.getValue("rep:principalName");
                    AccessControlEntry ace = this.createEntry(operations.get(primaryType), attributes);
                    this.addRestrictions(ace, attributes);
                    this.processCurrentAce = this.aclManager.addAccessControlEntry(principalName, ace);
                    if (this.processCurrentAce) {
                        this.entries.add(ace);
                    } else {
                        this.hasRejectedNodes = true;
                    }
                } else if ("rep:Restrictions".equals(primaryType) && !this.entries.isEmpty() && this.processCurrentAce) {
                    AccessControlEntry ace = this.entries.peek();
                    this.entries.add(ace);
                    this.addRestrictions(ace, attributes);
                }
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
            if (!this.onRepAclNode || !this.processCurrentAce) {
                this.handler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.onRepAclNode && this.processCurrentAce && !this.entries.isEmpty()) {
                this.entries.pop();
            } else {
                this.processCurrentAce = false;
                this.handler.endElement(uri, localName, qName);
            }
        }

        private static boolean isAccessControlEntry(@Nullable String primaryType) {
            return REP_GRANT_ACE.equals(primaryType) || REP_DENY_ACE.equals(primaryType);
        }

        static {
            operations.put(REP_GRANT_ACE, true);
            operations.put(REP_DENY_ACE, false);
        }
    }
}

