/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.support;

import org.apache.sling.event.impl.support.ExactTopicMatcher;
import org.apache.sling.event.impl.support.PackageTopicMatcher;
import org.apache.sling.event.impl.support.SubPackagesTopicMatcher;
import org.apache.sling.event.impl.support.TopicMatcher;

public abstract class TopicMatcherHelper {
    public static final TopicMatcher[] MATCH_ALL = new TopicMatcher[]{new TopicMatcher(){

        @Override
        public String match(String topic) {
            return topic;
        }
    }};

    public static TopicMatcher[] buildMatchers(String[] topicsParam) {
        TopicMatcher[] matchers;
        if (topicsParam == null || topicsParam.length == 0 || topicsParam.length == 1 && (topicsParam[0] == null || topicsParam[0].length() == 0)) {
            matchers = null;
        } else {
            TopicMatcher[] newMatchers = new TopicMatcher[topicsParam.length];
            for (int i = 0; i < topicsParam.length; ++i) {
                String value = topicsParam[i];
                if (value != null) {
                    value = value.trim();
                }
                if (value == null || value.length() <= 0) continue;
                if (value.equals("*")) {
                    return MATCH_ALL;
                }
                newMatchers[i] = value.endsWith(".") ? new PackageTopicMatcher(value) : (value.endsWith("*") ? new SubPackagesTopicMatcher(value) : new ExactTopicMatcher(value));
            }
            matchers = newMatchers;
        }
        return matchers;
    }
}

