/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.impl;

import javax.annotation.Nonnull;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.DistributionResponseInfo;
import org.jetbrains.annotations.NotNull;

public class SimpleDistributionResponse
implements DistributionResponse {
    private final DistributionRequestState state;
    private final String message;
    private final DistributionResponseInfo info;

    public SimpleDistributionResponse(DistributionRequestState state, String message, DistributionResponseInfo info) {
        this.state = state;
        this.message = message;
        if (info == null) {
            info = DistributionResponseInfo.NONE;
        }
        this.info = info;
    }

    public SimpleDistributionResponse(DistributionRequestState state, String message) {
        this(state, message, DistributionResponseInfo.NONE);
    }

    public boolean isSuccessful() {
        return DistributionRequestState.ACCEPTED.equals((Object)this.state) || DistributionRequestState.DISTRIBUTED.equals((Object)this.state);
    }

    @NotNull
    public DistributionRequestState getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public DistributionResponseInfo getDistributionInfo() {
        return this.info;
    }

    public String toString() {
        return "SimpleDistributionResponse{isSuccessful=" + this.isSuccessful() + ", state=" + this.state + ", message=" + this.message + ", info={id=" + this.info.getId() + "}" + '}';
    }
}

