/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak;

import java.util.Date;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.discovery.commons.providers.util.LogSilencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinerDelay
implements ClusterSyncService {
    private static final String NAME = JoinerDelay.class.getCanonicalName();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long timeoutMs;
    private final Scheduler scheduler;
    private Phase phase = Phase.IDLE;
    private Date absoluteTimeout;
    private final LogSilencer logSilencer = new LogSilencer(this.logger);

    public JoinerDelay(long timeoutMs, Scheduler scheduler) {
        this.timeoutMs = timeoutMs;
        this.scheduler = scheduler;
        if (timeoutMs <= 0L) {
            this.phase = Phase.DONE;
            this.logger.info("<init> : JoinerDelay is disabled (timeoutMs=" + timeoutMs + ")");
        } else {
            this.logger.info("<init> : JoinerDelay is enabled with timeoutMs=" + timeoutMs);
        }
    }

    private boolean joinerConditionApplies(BaseTopologyView view) {
        try {
            LocalClusterView localClusterView;
            ClusterView clusterView = view.getLocalInstance().getClusterView();
            if (clusterView.getInstances().size() > 1) {
                return true;
            }
            if (clusterView instanceof LocalClusterView && (localClusterView = (LocalClusterView)clusterView).hasPartiallyStartedInstances()) {
                this.logSilencer.infoOrDebug("joinerConditionApplies", "joinerConditionApplies : local cluster has partially started instances - delaying");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.error("joinerConditionApplies : got Exception, ignoring JoinerDelay (log level debug shows stacktrace): " + e);
            this.logger.debug("joinerConditionApplies : got Exception, ignoring JoinerDelay : " + e, (Throwable)e);
            return false;
        }
    }

    private final void assertCorrectThreadPool() {
        if (!Thread.currentThread().getName().contains("sling-discovery")) {
            this.logger.warn("assertCorrectThreadPool : not running as part of 'discovery' thread pool. Check configuration and ensure 'discovery' is in 'allowedPoolNames' of 'org.apache.sling.commons.scheduler'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(BaseTopologyView view, final Runnable callback) {
        boolean isPhaseDone;
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        JoinerDelay joinerDelay = this;
        synchronized (joinerDelay) {
            if (this.phase == Phase.IDLE) {
                if (this.joinerConditionApplies(view)) {
                    this.markDelaying();
                } else {
                    this.markDone();
                }
            }
            isPhaseDone = this.phase == Phase.DONE;
        }
        this.logSilencer.infoOrDebug("sync-status", "sync: isPhaseDone : " + isPhaseDone);
        if (isPhaseDone) {
            callback.run();
            return;
        }
        this.cancelSync();
        Job doContinue = new Job(){

            public void execute(JobContext context) {
                if (context != null) {
                    JoinerDelay.this.assertCorrectThreadPool();
                }
                JoinerDelay.this.markDone();
                callback.run();
            }
        };
        if (this.absoluteTimeout.compareTo(new Date()) < 0) {
            doContinue.execute(null);
        } else if (!this.scheduler.schedule((Object)doContinue, this.scheduler.AT(this.absoluteTimeout).name(NAME).threadPoolName("discovery"))) {
            this.logger.error("sync : schedule failed - ignoring JoinerDelay");
            doContinue.execute(null);
        }
    }

    public void cancelSync() {
        try {
            this.scheduler.unschedule(NAME);
        }
        catch (Exception e) {
            this.logger.warn("cancelSync: got Exception (log level debug shows stacktrace): " + e);
            this.logger.debug("cancelSync: got Exception : " + e, (Throwable)e);
        }
    }

    private final void markDelaying() {
        this.absoluteTimeout = new Date(System.currentTimeMillis() + this.timeoutMs);
        this.phase = Phase.DELAYING;
        this.logger.info("markDelaying : delaying topology join");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void markDone() {
        JoinerDelay joinerDelay = this;
        synchronized (joinerDelay) {
            if (this.absoluteTimeout == null && this.phase == Phase.DONE) {
                this.logger.warn("markDone : already marked done: absoluteTimeout = {}, phase = {}", (Object)this.absoluteTimeout, (Object)this.phase);
            }
            this.absoluteTimeout = null;
            this.phase = Phase.DONE;
            this.logger.info("markDone : no longer delaying topology join");
            this.logSilencer.reset();
        }
    }

    private static enum Phase {
        IDLE,
        DELAYING,
        DONE;

    }
}

