/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.apache.servicecomb.http.client.common.URLEndPoint;
import org.apache.servicecomb.http.client.event.EngineConnectChangedEvent;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AbstractAddressManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAddressManager.class);
    public static final String DEFAULT_PROJECT = "default";
    public static final String V4_PREFIX = "/v4/";
    private static final String V3_PREFIX = "/v3/";
    private static final String ZONE = "availableZone";
    private static final String REGION = "region";
    private static final int ISOLATION_THRESHOLD = 3;
    private volatile List<String> addresses = new ArrayList<String>();
    private final List<String> defaultAddress = new ArrayList<String>();
    private final List<String> defaultIsolationAddress = new ArrayList<String>();
    private int index;
    private String projectName;
    private final Map<String, Integer> addressFailureStatus = new ConcurrentHashMap<String, Integer>();
    private volatile List<String> availableZone = new ArrayList<String>();
    private final List<String> isolationZoneAddress = new ArrayList<String>();
    private volatile List<String> availableRegion = new ArrayList<String>();
    private final List<String> isolationRegionAddress = new ArrayList<String>();
    private boolean addressAutoRefreshed = false;
    private final Object lock = new Object();
    private final Random random = new Random();
    private EventBus eventBus;

    public AbstractAddressManager(List<String> addresses, String ownRegion, String ownAvailableZone) {
        this.projectName = DEFAULT_PROJECT;
        this.parseAndInitAddresses(addresses, ownRegion, ownAvailableZone, false);
        this.index = !addresses.isEmpty() ? this.getRandomIndex() : 0;
    }

    private void parseAndInitAddresses(List<String> addresses, String ownRegion, String ownAvailableZone, boolean isFormat) {
        if (CollectionUtils.isEmpty(addresses)) {
            return;
        }
        ArrayList<String> tempList = new ArrayList<String>();
        this.addressAutoRefreshed = addresses.stream().anyMatch(addr -> addr.contains(ZONE) || addr.contains(REGION));
        for (String address : addresses) {
            if (!address.startsWith("http")) {
                tempList.add(address);
                continue;
            }
            URLEndPoint endpoint = new URLEndPoint(address);
            tempList.add(endpoint.toString());
            this.buildAffinityAddress(endpoint, ownRegion, ownAvailableZone);
        }
        this.addresses.addAll(isFormat ? this.transformAddress(tempList) : tempList);
        this.defaultAddress.addAll(isFormat ? this.transformAddress(tempList) : tempList);
    }

    private void buildAffinityAddress(URLEndPoint endpoint, String ownRegion, String ownAvailableZone) {
        if (this.addressAutoRefreshed) {
            if (this.regionAndAZMatch(ownRegion, ownAvailableZone, endpoint.getFirst(REGION), endpoint.getFirst(ZONE))) {
                this.availableZone.add(endpoint.toString());
            } else {
                this.availableRegion.add(endpoint.toString());
            }
        }
    }

    public AbstractAddressManager(String projectName, List<String> addresses, String ownRegion, String ownAvailableZone) {
        this.projectName = StringUtils.isEmpty((CharSequence)projectName) ? DEFAULT_PROJECT : projectName;
        this.parseAndInitAddresses(addresses, ownRegion, ownAvailableZone, true);
        this.index = !addresses.isEmpty() ? this.getRandomIndex() : 0;
    }

    private int getRandomIndex() {
        return this.random.nextInt(this.addresses.size());
    }

    public void refreshEndpoint(RefreshEndpointEvent event, String key) {
        if (null == event || !event.getName().equals(key)) {
            return;
        }
        this.availableZone = event.getSameZone().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.availableRegion = event.getSameRegion().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.addressAutoRefreshed = true;
    }

    protected String normalizeUri(String endpoint) {
        return new URLEndPoint(endpoint).toString();
    }

    @VisibleForTesting
    Map<String, Integer> getAddressFailureStatus() {
        return this.addressFailureStatus;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public List<String> getAvailableZone() {
        return this.availableZone;
    }

    public List<String> getAvailableRegion() {
        return this.availableRegion;
    }

    public String formatUrl(String url, boolean absoluteUrl, String address) {
        return absoluteUrl ? address + url : this.formatAddress(address) + url;
    }

    public boolean sslEnabled() {
        return this.address().startsWith("https://");
    }

    protected List<String> transformAddress(List<String> addresses) {
        return addresses.stream().map(this::formatAddress).collect(Collectors.toList());
    }

    protected String formatAddress(String address) {
        try {
            return this.getUrlPrefix(address) + HttpUtils.encodeURLParam(this.projectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("not possible");
        }
    }

    protected String getUrlPrefix(String address) {
        return address + V3_PREFIX;
    }

    public String address() {
        if (!this.addressAutoRefreshed) {
            return this.getDefaultAddress();
        }
        return this.getAvailableZoneAddress();
    }

    private String getDefaultAddress() {
        if (!this.addresses.isEmpty()) {
            return this.getCurrentAddress(this.addresses);
        }
        LOGGER.warn("all addresses are isolation, please check server status.");
        return this.getCurrentAddress(this.defaultAddress);
    }

    private String getAvailableZoneAddress() {
        List<String> zoneOrRegionAddress = this.getZoneOrRegionAddress();
        if (!zoneOrRegionAddress.isEmpty()) {
            return this.getCurrentAddress(zoneOrRegionAddress);
        }
        LOGGER.warn("all auto discovery addresses are isolation, please check server status.");
        return this.getDefaultAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentAddress(List<String> addresses) {
        AbstractAddressManager abstractAddressManager = this;
        synchronized (abstractAddressManager) {
            ++this.index;
            if (this.index >= addresses.size()) {
                this.index = 0;
            }
            return addresses.get(this.index);
        }
    }

    private List<String> getZoneOrRegionAddress() {
        ArrayList<String> results = new ArrayList<String>();
        if (!this.availableZone.isEmpty()) {
            results.addAll(this.availableZone);
        } else {
            results.addAll(this.availableRegion);
        }
        return results;
    }

    public void recordSuccessState(String address) {
        this.resetFailureStatus(address);
        if (this.addressAutoRefreshed) {
            if (this.isolationZoneAddress.remove(address)) {
                LOGGER.warn("restore same region address [{}]", (Object)address);
                if (this.eventBus != null && this.availableZone.isEmpty()) {
                    this.eventBus.post((Object)new EngineConnectChangedEvent());
                }
                this.availableZone.add(address);
                return;
            }
            if (this.isolationRegionAddress.remove(address)) {
                LOGGER.warn("restore same zone address [{}]", (Object)address);
                this.availableRegion.add(address);
            }
            return;
        }
        if (this.defaultIsolationAddress.remove(address)) {
            LOGGER.warn("restore default address [{}]", (Object)address);
            this.addresses.add(address);
        }
    }

    public void resetFailureStatus(String address) {
        this.addressFailureStatus.put(address, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFailState(String address) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.addressFailureStatus.containsKey(address)) {
                this.addressFailureStatus.put(address, 1);
                return;
            }
            int number = this.addressFailureStatus.get(address) + 1;
            if (number < 3) {
                this.addressFailureStatus.put(address, number);
            } else {
                this.removeAddress(address);
            }
        }
    }

    @VisibleForTesting
    void removeAddress(String address) {
        if (!this.addressAutoRefreshed) {
            if (this.addresses.remove(address)) {
                LOGGER.warn("isolation default address [{}]", (Object)address);
                this.defaultIsolationAddress.add(address);
            }
            return;
        }
        if (this.availableZone.remove(address)) {
            LOGGER.warn("isolation same zone address [{}]", (Object)address);
            this.isolationZoneAddress.add(address);
            if (this.eventBus != null && this.availableZone.isEmpty() && !this.availableRegion.isEmpty()) {
                this.eventBus.post((Object)new EngineConnectChangedEvent());
            }
            return;
        }
        if (this.availableRegion.remove(address)) {
            LOGGER.warn("isolation same region address [{}]", (Object)address);
            this.isolationRegionAddress.add(address);
        }
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public List<String> getIsolationAddresses() {
        ArrayList<String> isolationAddresses = new ArrayList<String>(this.defaultIsolationAddress);
        isolationAddresses.addAll(this.isolationZoneAddress);
        isolationAddresses.addAll(this.isolationRegionAddress);
        return isolationAddresses;
    }

    public String compareAndGetAddress(String host) {
        for (String address : this.defaultAddress) {
            if (!this.isAddressHostSame(address, host)) continue;
            return address;
        }
        return "";
    }

    private boolean isAddressHostSame(String address, String host) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            return false;
        }
        try {
            URI uri = new URI(address);
            return host.equals(uri.getHost());
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred while constructing URI using the address [{}]", (Object)address);
            return false;
        }
    }

    private boolean regionAndAZMatch(String ownRegion, String ownAvailableZone, String engineRegion, String engineAvailableZone) {
        return ownRegion.equalsIgnoreCase(engineRegion) && ownAvailableZone.equals(engineAvailableZone);
    }

    public void refreshAffinityAddress(Set<String> sameZone, Set<String> sameRegion) {
        this.addressAutoRefreshed = true;
        if (!sameZone.isEmpty()) {
            this.availableZone.addAll(sameZone);
        }
        if (!sameRegion.isEmpty()) {
            this.availableRegion.addAll(sameRegion);
        }
    }
}

