/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.concurrent;

import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.concurrent.SingleThreadExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DefaultSingleThreadExecutor
implements SingleThreadExecutor {
    private final SingleThreadExecutor singleThreadExecutor;

    public DefaultSingleThreadExecutor(ExecutorService singleThreadExecutorService) {
        this.singleThreadExecutor = DefaultSingleThreadExecutor.wrapSingleThreadExecutor(singleThreadExecutorService);
    }

    public DefaultSingleThreadExecutor(String poolName, int maxPendingTasks) {
        this.singleThreadExecutor = DefaultSingleThreadExecutor.createSingleThreadExecutor(poolName, maxPendingTasks);
    }

    @Override
    public void execute(Runnable task) {
        this.singleThreadExecutor.execute(task);
    }

    @Override
    public boolean shutdownGracefully() {
        return this.singleThreadExecutor.shutdownGracefully();
    }

    @Override
    public boolean shutdownGracefully(long timeout, TimeUnit unit) {
        return this.singleThreadExecutor.shutdownGracefully(timeout, unit);
    }

    private static SingleThreadExecutor wrapSingleThreadExecutor(final ExecutorService executor) {
        if (executor instanceof SingleThreadExecutor) {
            return (SingleThreadExecutor)((Object)executor);
        }
        return new SingleThreadExecutor(){

            @Override
            public boolean shutdownGracefully() {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(executor);
            }

            @Override
            public boolean shutdownGracefully(long timeout, TimeUnit unit) {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(executor, unit.toMillis(timeout));
            }

            @Override
            public void execute(Runnable command) {
                executor.execute(command);
            }
        };
    }

    private static SingleThreadExecutor createSingleThreadExecutor(String poolName, int maxPendingTasks) {
        final ThreadPoolExecutor singleThreadPool = ThreadPoolUtil.newBuilder().poolName(poolName).enableMetric(true).coreThreads(1).maximumThreads(1).keepAliveSeconds(60L).workQueue(new LinkedBlockingQueue<Runnable>(maxPendingTasks)).threadFactory(new NamedThreadFactory(poolName, true)).build();
        return new SingleThreadExecutor(){

            @Override
            public boolean shutdownGracefully() {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(singleThreadPool);
            }

            @Override
            public boolean shutdownGracefully(long timeout, TimeUnit unit) {
                return ExecutorServiceHelper.shutdownAndAwaitTermination(singleThreadPool, unit.toMillis(timeout));
            }

            @Override
            public void execute(Runnable command) {
                singleThreadPool.execute(command);
            }
        };
    }
}

