/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setAttributeNodeNS Adds a new attribute and raises an WRONG_DOCUMENT_ERR if this node
 * is readonly.
 * Attempt to add an attribute node to an element node which is part of the replacement text of
 * a read-only EntityReference node.
 * Check if a NO_MODIFICATION_ALLOWED_ERR is thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
 */
public class elementsetattributenodens06 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        Element element = doc.createElementNS("http://www.w3.org/DOM/Test", "elem1");
        Attr attribute = doc.createAttributeNS("http://www.w3.org/DOM/Test", "attr");
        EntityReference entRef = doc.createEntityReference("ent4");
        Node newChild = attribute.appendChild(entRef);
        Node newAttribute = element.setAttributeNodeNS(attribute);
        NodeList elementList = entRef.getChildNodes();
        Element element2 = (Element) elementList.item(0);
        Attr attribute2 = doc.createAttributeNS("http://www.w3.org/DOM/Test", "attr2");

        DOMException ex = assertThrows(DOMException.class, () -> element2.setAttributeNodeNS(attribute2));
        assertEquals(DOMException.NO_MODIFICATION_ALLOWED_ERR, ex.code, "elementsetattributenodens06");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributenodens06";
    }

}
