/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ReservedIndexGroups {
  ADSIGRP_SYMTAB((long) 0x0000F000L),
  ADSIGRP_SYMNAME((long) 0x0000F001L),
  ADSIGRP_SYMVAL((long) 0x0000F002L),
  ADSIGRP_SYM_HNDBYNAME((long) 0x0000F003L),
  ADSIGRP_SYM_VALBYNAME((long) 0x0000F004L),
  ADSIGRP_SYM_VALBYHND((long) 0x0000F005L),
  ADSIGRP_SYM_RELEASEHND((long) 0x0000F006L),
  ADSIGRP_SYM_INFOBYNAME((long) 0x0000F007L),
  ADSIGRP_SYM_VERSION((long) 0x0000F008L),
  ADSIGRP_SYM_INFOBYNAMEEX((long) 0x0000F009L),
  ADSIGRP_SYM_DOWNLOAD((long) 0x0000F00AL),
  ADSIGRP_SYM_UPLOAD((long) 0x0000F00BL),
  ADSIGRP_SYM_UPLOADINFO((long) 0x0000F00CL),
  ADSIGRP_DATA_TYPE_TABLE_UPLOAD((long) 0x0000F00EL),
  ADSIGRP_SYMBOL_AND_DATA_TYPE_SIZES((long) 0x0000F00FL),
  ADSIGRP_SYMNOTE((long) 0x0000F010L),
  ADSIGRP_DT_INFOBYNAMEEX((long) 0x0000F011L),
  ADSIGRP_IOIMAGE_RWIB((long) 0x0000F020L),
  ADSIGRP_IOIMAGE_RWIX((long) 0x0000F021L),
  ADSIGRP_IOIMAGE_RISIZE((long) 0x0000F025L),
  ADSIGRP_IOIMAGE_RWOB((long) 0x0000F030L),
  ADSIGRP_IOIMAGE_RWOX((long) 0x0000F031L),
  ADSIGRP_IOIMAGE_RWOSIZE((long) 0x0000F035L),
  ADSIGRP_IOIMAGE_CLEARI((long) 0x0000F040L),
  ADSIGRP_IOIMAGE_CLEARO((long) 0x0000F050L),
  ADSIGRP_IOIMAGE_RWIOB((long) 0x0000F060L),
  ADSIGRP_MULTIPLE_READ((long) 0x0000F080L),
  ADSIGRP_MULTIPLE_WRITE((long) 0x0000F081L),
  ADSIGRP_MULTIPLE_READ_WRITE((long) 0x0000F082L),
  ADSIGRP_MULTIPLE_RELEASE_HANDLE((long) 0x0000F083L),
  ADSIGRP_SUMUP_READEX2((long) 0x0000F084L),
  ADSIGRP_MULTIPLE_ADD_DEVICE_NOTIFICATIONS((long) 0x0000F085L),
  ADSIGRP_MULTIPLE_DELETE_DEVICE_NOTIFICATIONS((long) 0x0000F086L),
  ADSIGRP_DEVICE_DATA((long) 0x0000F100L),
  ADS_OVER_ETHERCAT((long) 0x0000F302L),
  ADSIOFFS_DEVDATA_ADSSTATE((long) 0x00000000L),
  ADSIOFFS_DEVDATA_DEVSTATE((long) 0x00000002L);
  private static final Map<Long, ReservedIndexGroups> map;

  static {
    map = new HashMap<>();
    for (ReservedIndexGroups value : ReservedIndexGroups.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  ReservedIndexGroups(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static ReservedIndexGroups enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
