/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSet;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSetPart;
import org.apache.olingo.odata2.api.client.batch.BatchPart;
import org.apache.olingo.odata2.api.client.batch.BatchQueryPart;
import org.apache.olingo.odata2.core.batch.BatchHelper;

public class BatchRequestWriter {
    private static final String REG_EX_BOUNDARY = "([a-zA-Z0-9_\\-\\.'\\+]{1,70})|\"([a-zA-Z0-9_\\-\\.'\\+\\s\\(\\),/:=\\?]{1,69}[a-zA-Z0-9_\\-\\.'\\+\\(\\),/:=\\?])\"";
    private static final String COLON = ":";
    private static final String SP = " ";
    private static final String CRLF = "\r\n";
    public static final String BOUNDARY_PREAMBLE = "changeset";
    public static final String HTTP_1_1 = "HTTP/1.1";
    private String batchBoundary;
    private BatchHelper.BodyBuilder writer = new BatchHelper.BodyBuilder();

    public InputStream writeBatchRequest(List<BatchPart> batchParts, String boundary) {
        if (!boundary.matches(REG_EX_BOUNDARY)) {
            throw new IllegalArgumentException();
        }
        this.batchBoundary = boundary;
        for (BatchPart batchPart : batchParts) {
            this.writer.append("--").append(boundary).append(CRLF);
            if (batchPart instanceof BatchChangeSet) {
                this.appendChangeSet((BatchChangeSet)batchPart);
                continue;
            }
            if (!(batchPart instanceof BatchQueryPart)) continue;
            BatchQueryPart request = (BatchQueryPart)batchPart;
            this.appendRequestBodyPart(request);
        }
        this.writer.append("--").append(boundary).append("--");
        ByteArrayInputStream batchRequestBody = new ByteArrayInputStream(this.writer.getContent());
        return batchRequestBody;
    }

    private void appendChangeSet(BatchChangeSet batchChangeSet) {
        String boundary = BatchHelper.generateBoundary(BOUNDARY_PREAMBLE);
        while (boundary.equals(this.batchBoundary) || !boundary.matches(REG_EX_BOUNDARY)) {
            boundary = BatchHelper.generateBoundary(BOUNDARY_PREAMBLE);
        }
        this.writer.append("Content-Type").append(COLON).append(SP).append("multipart/mixed; boundary=" + boundary).append(CRLF);
        for (BatchChangeSetPart request : batchChangeSet.getChangeSetParts()) {
            this.writer.append(CRLF).append("--").append(boundary).append(CRLF);
            this.appendRequestBodyPart(request);
        }
        this.writer.append(CRLF).append("--").append(boundary).append("--").append(CRLF);
    }

    private void appendRequestBodyPart(BatchQueryPart request) {
        this.appendRequestBodyPart(request.getMethod(), request.getUri(), request.getHeaders(), new BatchHelper.Body(), request.getContentId());
    }

    private void appendRequestBodyPart(BatchChangeSetPart request) {
        this.appendRequestBodyPart(request.getMethod(), request.getUri(), request.getHeaders(), new BatchHelper.Body(request), request.getContentId());
    }

    private void appendRequestBodyPart(String method, String uri, Map<String, String> headers, BatchHelper.Body body, String contentId) {
        String contentLength;
        boolean isContentLengthPresent = false;
        this.writer.append("Content-Type").append(COLON).append(SP).append("application/http").append(CRLF);
        this.writer.append("Content-Transfer-Encoding").append(COLON).append(SP).append("binary").append(CRLF);
        if (contentId != null) {
            this.writer.append("Content-Id").append(COLON).append(SP).append(contentId).append(CRLF);
        }
        if ((contentLength = this.getHeaderValue(headers, "Content-Length")) != null && !contentLength.isEmpty()) {
            isContentLengthPresent = true;
        }
        this.writer.append(CRLF);
        this.writer.append(method).append(SP).append(uri).append(SP).append(HTTP_1_1);
        this.writer.append(CRLF);
        if (!isContentLengthPresent && !body.isEmpty()) {
            this.writer.append("Content-Length").append(COLON).append(SP).append(body.getLength()).append(CRLF);
        }
        this.appendHeader(headers);
        this.writer.append(CRLF);
        if (!body.isEmpty()) {
            this.writer.append(body);
        } else {
            this.writer.append(CRLF);
        }
    }

    private void appendHeader(Map<String, String> headers) {
        for (Map.Entry<String, String> headerMap : headers.entrySet()) {
            String name = headerMap.getKey();
            this.writer.append(name).append(COLON).append(SP).append(headerMap.getValue()).append(CRLF);
        }
    }

    private String getHeaderValue(Map<String, String> headers, String headerName) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (!headerName.equalsIgnoreCase(header.getKey())) continue;
            return header.getValue();
        }
        return null;
    }
}

