/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.callback;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.OnWriteEntryContent;
import org.apache.olingo.odata2.api.ep.callback.OnWriteFeedContent;
import org.apache.olingo.odata2.api.ep.callback.WriteCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackResult;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackResult;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.NavigationPropertySegment;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;

public class JPAExpandCallBack
implements OnWriteFeedContent,
OnWriteEntryContent,
ODataCallback {
    private URI baseUri;
    private List<ArrayList<NavigationPropertySegment>> expandList;
    private EdmEntitySet nextEntitySet = null;
    private HashMap<String, List<EdmProperty>> edmPropertyMap = new HashMap();

    private JPAExpandCallBack(URI baseUri, List<ArrayList<NavigationPropertySegment>> expandList) {
        this.baseUri = baseUri;
        this.expandList = expandList;
    }

    public WriteEntryCallbackResult retrieveEntryResult(WriteEntryCallbackContext context) throws ODataApplicationException {
        WriteEntryCallbackResult result = new WriteEntryCallbackResult();
        Map entry = context.getEntryData();
        HashMap<String, Object> edmPropertyValueMap = null;
        ArrayList<EdmNavigationProperty> currentNavPropertyList = null;
        Map navigationLinks = null;
        JPAEntityParser jpaResultParser = new JPAEntityParser();
        EdmNavigationProperty currentNavigationProperty = context.getNavigationProperty();
        try {
            Object inlinedEntry = entry.get(currentNavigationProperty.getName());
            if (this.nextEntitySet == null) {
                this.nextEntitySet = context.getSourceEntitySet().getRelatedEntitySet(currentNavigationProperty);
            }
            edmPropertyValueMap = jpaResultParser.parse2EdmPropertyValueMap(inlinedEntry, (EdmStructuralType)this.nextEntitySet.getEntityType());
            result.setEntryData(edmPropertyValueMap);
            navigationLinks = context.getCurrentExpandSelectTreeNode().getLinks();
            if (navigationLinks.size() > 0) {
                currentNavPropertyList = new ArrayList<EdmNavigationProperty>();
                List<EdmNavigationProperty> nextNavProperty = this.getNextNavigationProperty(context.getSourceEntitySet().getEntityType(), context.getNavigationProperty());
                if (nextNavProperty != null) {
                    currentNavPropertyList.addAll(nextNavProperty);
                }
                HashMap<String, Object> navigationMap = jpaResultParser.parse2EdmNavigationValueMap(inlinedEntry, currentNavPropertyList);
                if (edmPropertyValueMap != null) {
                    edmPropertyValueMap.putAll(navigationMap);
                }
                result.setEntryData(edmPropertyValueMap);
            }
            result.setInlineProperties(this.getInlineEntityProviderProperties((WriteCallbackContext)context));
        }
        catch (EdmException e) {
            throw new ODataApplicationException(e.getMessage(), Locale.getDefault(), (Throwable)e);
        }
        catch (ODataJPARuntimeException e) {
            throw new ODataApplicationException(e.getMessage(), Locale.getDefault(), (Throwable)e);
        }
        return result;
    }

    private List<EdmProperty> getEdmProperties(EdmEntitySet entitySet, ExpandSelectTreeNode expandTreeNode) throws ODataApplicationException {
        try {
            String name = entitySet.getName();
            if (this.edmPropertyMap.containsKey(name)) {
                return this.edmPropertyMap.get(name);
            }
            ArrayList<EdmProperty> edmProperties = new ArrayList<EdmProperty>();
            edmProperties.addAll(expandTreeNode.getProperties());
            boolean hit = false;
            for (EdmProperty keyProperty : entitySet.getEntityType().getKeyProperties()) {
                hit = false;
                for (EdmProperty property : edmProperties) {
                    if (!property.getName().equals(keyProperty.getName())) continue;
                    hit = true;
                    break;
                }
                if (hit) continue;
                edmProperties.add(keyProperty);
            }
            this.edmPropertyMap.put(name, edmProperties);
            return edmProperties;
        }
        catch (EdmException e) {
            throw new ODataApplicationException(e.getMessage(), Locale.getDefault(), (Throwable)e);
        }
    }

    public WriteFeedCallbackResult retrieveFeedResult(WriteFeedCallbackContext context) throws ODataApplicationException {
        WriteFeedCallbackResult result = new WriteFeedCallbackResult();
        HashMap inlinedEntry = (HashMap)context.getEntryData();
        List<Object> edmEntityList = new ArrayList();
        JPAEntityParser jpaResultParser = new JPAEntityParser();
        ArrayList<EdmNavigationProperty> currentNavPropertyList = null;
        EdmNavigationProperty currentNavigationProperty = context.getNavigationProperty();
        ExpandSelectTreeNode currentExpandTreeNode = context.getCurrentExpandSelectTreeNode();
        try {
            Collection listOfItems = (Collection)inlinedEntry.get(context.getNavigationProperty().getName());
            if (this.nextEntitySet == null) {
                this.nextEntitySet = context.getSourceEntitySet().getRelatedEntitySet(currentNavigationProperty);
            }
            edmEntityList = !currentExpandTreeNode.getProperties().isEmpty() ? jpaResultParser.parse2EdmEntityList((Collection<Object>)listOfItems, this.getEdmProperties(this.nextEntitySet, currentExpandTreeNode)) : jpaResultParser.parse2EdmEntityList((Collection<Object>)listOfItems, (EdmStructuralType)this.nextEntitySet.getEntityType());
            result.setFeedData(edmEntityList);
            if (currentExpandTreeNode.getLinks().size() > 0) {
                currentNavPropertyList = new ArrayList<EdmNavigationProperty>();
                List<EdmNavigationProperty> nextNavPropertyList = this.getNextNavigationProperty(context.getSourceEntitySet().getEntityType(), context.getNavigationProperty());
                if (nextNavPropertyList != null) {
                    currentNavPropertyList.addAll(nextNavPropertyList);
                }
                int count = 0;
                for (Object object : listOfItems) {
                    HashMap<String, Object> navigationMap = jpaResultParser.parse2EdmNavigationValueMap(object, currentNavPropertyList);
                    ((Map)edmEntityList.get(count)).putAll(navigationMap);
                    ++count;
                }
                result.setFeedData(edmEntityList);
            }
            result.setInlineProperties(this.getInlineEntityProviderProperties((WriteCallbackContext)context));
        }
        catch (EdmException e) {
            throw new ODataApplicationException(e.getMessage(), Locale.getDefault(), (Throwable)e);
        }
        catch (ODataJPARuntimeException e) {
            throw new ODataApplicationException(e.getMessage(), Locale.getDefault(), (Throwable)e);
        }
        return result;
    }

    private List<EdmNavigationProperty> getNextNavigationProperty(EdmEntityType sourceEntityType, EdmNavigationProperty navigationProperty) throws EdmException {
        ArrayList<EdmNavigationProperty> edmNavigationPropertyList = new ArrayList<EdmNavigationProperty>();
        for (ArrayList<NavigationPropertySegment> navPropSegments : this.expandList) {
            int size = navPropSegments.size();
            for (int i = 0; i < size; ++i) {
                EdmNavigationProperty navProperty = navPropSegments.get(i).getNavigationProperty();
                if (!this.testNavPropertySegment(navProperty, sourceEntityType, navigationProperty) || i >= size - 1) continue;
                edmNavigationPropertyList.add(navPropSegments.get(i + 1).getNavigationProperty());
            }
        }
        return edmNavigationPropertyList;
    }

    private boolean testNavPropertySegment(EdmNavigationProperty navProperty, EdmEntityType sourceEntityType, EdmNavigationProperty navigationProperty) throws EdmException {
        String roleNum;
        if (navigationProperty.getFromRole().toLowerCase(Locale.ENGLISH).startsWith(sourceEntityType.getName().toLowerCase(Locale.ENGLISH)) && (roleNum = navigationProperty.getFromRole().substring(sourceEntityType.getName().length())).length() > 0) {
            try {
                Integer.parseInt(roleNum);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return navProperty.getName().equals(navigationProperty.getName());
    }

    public static Map<String, ODataCallback> getCallbacks(URI baseUri, ExpandSelectTreeNode expandSelectTreeNode, List<ArrayList<NavigationPropertySegment>> expandList) throws EdmException {
        HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
        for (String navigationPropertyName : expandSelectTreeNode.getLinks().keySet()) {
            callbacks.put(navigationPropertyName, new JPAExpandCallBack(baseUri, expandList));
        }
        return callbacks;
    }

    private EntityProviderWriteProperties getInlineEntityProviderProperties(WriteCallbackContext context) throws EdmException {
        EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)this.baseUri);
        propertiesBuilder.callbacks(JPAExpandCallBack.getCallbacks(this.baseUri, context.getCurrentExpandSelectTreeNode(), this.expandList));
        propertiesBuilder.expandSelectTree(context.getCurrentExpandSelectTreeNode());
        return propertiesBuilder.build();
    }
}

