/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.nifi.utils.NarDependencyUtils;
import org.eclipse.aether.RepositorySystemSession;

@Mojo(name="duplicate-nar-dependencies", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NarDuplicateDependenciesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Inject
    private DependencyCollectorBuilder dependencyCollectorBuilder;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;
    @Inject
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            NarDependencyUtils.ensureSingleNarDependencyExists(this.project);
            DefaultProjectBuildingRequest narRequest = new DefaultProjectBuildingRequest();
            narRequest.setRepositorySession(this.repoSession);
            narRequest.setSystemProperties(System.getProperties());
            this.artifactHandlerManager.addHandlers(NarDependencyUtils.createNarHandlerMap((ProjectBuildingRequest)narRequest, this.project, this.projectBuilder));
            final DependencyNode root = this.dependencyCollectorBuilder.collectDependencyGraph((ProjectBuildingRequest)narRequest, null);
            DependencyNode narParent = root.getChildren().stream().filter(child -> "nar".equals(child.getArtifact().getType())).findFirst().orElseThrow(() -> new MojoExecutionException("Project does not have any NAR dependencies."));
            this.getLog().info((CharSequence)("Analyzing dependencies of " + narRequest.getProject().getFile().getPath()));
            final HashMap directDependencies = new HashMap();
            root.accept(new DependencyNodeVisitor(){
                final Stack<Artifact> hierarchy = new Stack();

                public boolean visit(DependencyNode node) {
                    if (node == root) {
                        return true;
                    }
                    Artifact artifact = node.getArtifact();
                    this.hierarchy.push(artifact);
                    if ("compile".equals(artifact.getScope()) && !"nar".equals(artifact.getType())) {
                        directDependencies.put(artifact.toString(), new ArrayList<Artifact>(this.hierarchy));
                        return true;
                    }
                    return false;
                }

                public boolean endVisit(DependencyNode node) {
                    if (node != root) {
                        this.hierarchy.pop();
                    }
                    return true;
                }
            });
            final HashMap errors = new HashMap();
            narParent.accept(new DependencyNodeVisitor(){
                final Stack<Artifact> hierarchy = new Stack();

                public boolean visit(DependencyNode node) {
                    Artifact artifact = node.getArtifact();
                    this.hierarchy.push(artifact);
                    if ("compile".equals(artifact.getScope()) && directDependencies.containsKey(artifact.toString())) {
                        int i;
                        StringBuilder sb = new StringBuilder().append(root.getArtifact()).append(" (this nar)").append(System.lineSeparator());
                        List otherHierarchy = (List)directDependencies.get(artifact.toString());
                        for (i = 0; i < otherHierarchy.size(); ++i) {
                            sb.append(NarDuplicateDependenciesMojo.this.indent(i)).append(otherHierarchy.get(i));
                            if (i == otherHierarchy.size() - 1) {
                                sb.append(" (duplicate)");
                            }
                            sb.append(System.lineSeparator());
                        }
                        for (i = 0; i < this.hierarchy.size(); ++i) {
                            sb.append(NarDuplicateDependenciesMojo.this.indent(i)).append(this.hierarchy.get(i));
                            if (i == this.hierarchy.size() - 1) {
                                sb.append(" (already included here)");
                            }
                            sb.append(System.lineSeparator());
                        }
                        errors.computeIfAbsent(artifact.toString(), k -> new ArrayList()).add(sb.toString());
                    }
                    return true;
                }

                public boolean endVisit(DependencyNode node) {
                    this.hierarchy.pop();
                    return true;
                }
            });
            for (Map.Entry entry : errors.entrySet()) {
                StringBuilder sb = new StringBuilder().append((String)entry.getKey()).append(" is already included in the nar");
                if (((List)entry.getValue()).size() > 1) {
                    sb.append(" multiple times");
                }
                sb.append(":");
                for (String error : (List)entry.getValue()) {
                    sb.append(System.lineSeparator()).append(error);
                }
                this.getLog().error((CharSequence)sb.toString());
            }
            if (!errors.isEmpty()) {
                this.getLog().info((CharSequence)"Consider changing the scope from \"compile\" to \"provided\" or exclude it in case it's a transitive dependency.");
                throw new MojoFailureException("Found duplicate dependencies");
            }
        }
        catch (ProjectBuildingException | DependencyCollectorBuilderException e) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)e);
        }
    }

    private String indent(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("|  ");
        }
        sb.append("+- ");
        return sb.toString();
    }
}

