/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.access;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.documentation.init.NopComponentLog;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.security.krb.KerberosAction;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosTicketCacheUser;
import org.apache.nifi.security.krb.KerberosUser;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.util.StringUtils;

public class GetAccessTokenSpnego
extends AbstractNiFiCommand<StringResult> {
    public GetAccessTokenSpnego() {
        super("get-access-token-spnego", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Authenticates to NiFi via SPNEGO and returns an access token for use on future requests as the value of the " + CommandOption.BEARER_TOKEN.getLongName() + " argument. If a keytab or password is not specified, then the ticket cache will be used and it is assumed that a kinit was done for the given principal outside of the CLI.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.KERBEROS_PRINCIPAL.createOption());
        this.addOption(CommandOption.KERBEROS_KEYTAB.createOption());
        this.addOption(CommandOption.KERBEROS_PASSWORD.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        Object kerberosUser;
        String principal = this.getRequiredArg(properties, CommandOption.KERBEROS_PRINCIPAL);
        String keytab = this.getArg(properties, CommandOption.KERBEROS_KEYTAB);
        String password = this.getArg(properties, CommandOption.KERBEROS_PASSWORD);
        if (!StringUtils.isBlank((String)keytab) && !StringUtils.isBlank((String)password)) {
            throw new MissingOptionException("Only one of keytab or password can be specified");
        }
        if (!StringUtils.isBlank((String)keytab)) {
            File keytabFile = new File(keytab);
            if (!keytabFile.exists()) {
                throw new CommandException("Unable to find keytab file at: " + keytabFile.getAbsolutePath());
            }
            kerberosUser = new KerberosKeytabUser(principal, keytab);
        } else {
            kerberosUser = !StringUtils.isBlank((String)password) ? new KerberosPasswordUser(principal, password) : new KerberosTicketCacheUser(principal);
        }
        KerberosAction kerberosAction = new KerberosAction((KerberosUser)kerberosUser, () -> client.getAccessClient().getTokenFromKerberosTicket(), (ComponentLog)new NopComponentLog());
        String token = (String)kerberosAction.execute();
        return new StringResult(token, this.getContext().isInteractive());
    }
}

