/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.faces.context.ExternalContext;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.servlet.ServletRequest;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.RequestType;

@ExcludeFromManagedRequestScope
public class RequestStateMap
extends HashMap<String, Object> {
    private static final String _STATE_MAP = RequestStateMap.class.getName();
    private static final long serialVersionUID = 1L;

    public static RequestStateMap getInstance(ServletRequest req) {
        RequestStateMap map = (RequestStateMap)req.getAttribute(_STATE_MAP);
        if (map == null) {
            map = new RequestStateMap();
            req.setAttribute(_STATE_MAP, (Object)map);
        }
        return map;
    }

    public static RequestStateMap getInstance(ExternalContext ec) {
        String uuid;
        Map reqMap = ec.getRequestMap();
        RequestStateMap map = (RequestStateMap)reqMap.get(_STATE_MAP);
        if (!ExternalContextUtils.isRequestFromClient(ec) && (uuid = (String)ec.getRequestParameterMap().get(_STATE_MAP)) != null) {
            RequestStateMap myMap = (RequestStateMap)ec.getSessionMap().remove(_STATE_MAP + "." + uuid);
            if (map == null) {
                map = myMap;
                reqMap.put(_STATE_MAP, map);
            }
        }
        if (map == null) {
            map = new RequestStateMap();
            reqMap.put(_STATE_MAP, map);
        }
        return map;
    }

    private RequestStateMap() {
    }

    public void saveState(ExternalContext ec) {
        RequestType type = ExternalContextUtils.getRequestType(ec);
        if (type.isPortlet() && !type.isResponseWritable()) {
            try {
                Object actionResp = ec.getResponse();
                Method m = actionResp.getClass().getMethod("setRenderParameter", String.class, String.class);
                String uuid = UUID.randomUUID().toString();
                ec.getSessionMap().put(_STATE_MAP + "." + uuid, this);
                m.invoke(actionResp, _STATE_MAP, uuid);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

