/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.model.DataModel;
import org.apache.myfaces.trinidad.model.LocalRowKeyIndex;
import org.apache.myfaces.trinidad.model.RowKeyChangeEvent;
import org.apache.myfaces.trinidad.model.RowKeyChangeListener;
import org.apache.myfaces.trinidad.model.RowKeyIndex;
import org.apache.myfaces.trinidad.model.SortCriterion;

public abstract class CollectionModel
extends DataModel
implements RowKeyIndex,
LocalRowKeyIndex {
    private List<RowKeyChangeListener> _rowKeyChangeListeners = new ArrayList<RowKeyChangeListener>(3);

    @Override
    public abstract Object getRowKey();

    @Override
    public abstract void setRowKey(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRowAvailable(int rowIndex) {
        int oldIndex = this.getRowIndex();
        try {
            this.setRowIndex(rowIndex);
            boolean bl = this.isRowAvailable();
            return bl;
        }
        finally {
            this.setRowIndex(oldIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRowAvailable(Object rowKey) {
        Object oldKey = this.getRowKey();
        try {
            this.setRowKey(rowKey);
            boolean bl = this.isRowAvailable();
            return bl;
        }
        finally {
            this.setRowKey(oldKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRowData(int rowIndex) {
        int oldIndex = this.getRowIndex();
        try {
            this.setRowIndex(rowIndex);
            Object object = this.getRowData();
            return object;
        }
        finally {
            this.setRowIndex(oldIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRowData(Object rowKey) {
        Object oldKey = this.getRowKey();
        try {
            this.setRowKey(rowKey);
            Object object = this.getRowData();
            return object;
        }
        finally {
            this.setRowKey(oldKey);
        }
    }

    public boolean isSortable(String property) {
        return false;
    }

    public List<SortCriterion> getSortCriteria() {
        return Collections.emptyList();
    }

    public void setSortCriteria(List<SortCriterion> criteria) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areRowsAvailable(int startIndex, int rowsToCheck) {
        int oldIndex = this.getRowIndex();
        try {
            if (rowsToCheck < 0) {
                rowsToCheck = Math.abs(rowsToCheck);
                startIndex = startIndex - rowsToCheck + 1;
            }
            this.setRowIndex(startIndex);
            boolean bl = this.areRowsAvailable(rowsToCheck);
            return bl;
        }
        finally {
            this.setRowIndex(oldIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areRowsAvailable(Object startRowKey, int rowsToCheck) {
        Object oldKey = this.getRowKey();
        try {
            this.setRowKey(startRowKey);
            boolean bl = this.areRowsAvailable(rowsToCheck);
            return bl;
        }
        finally {
            this.setRowKey(oldKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areRowsAvailable(int rowsToCheck) {
        int startIndex = this.getRowIndex();
        if (startIndex < 0 || rowsToCheck <= 0) {
            return false;
        }
        long count = this.getRowCount();
        if (count != -1L) {
            if ((long)startIndex >= count) {
                return false;
            }
            if ((long)(startIndex + rowsToCheck) > count) {
                rowsToCheck = (int)count - startIndex;
            }
        }
        int last = startIndex + rowsToCheck - 1;
        try {
            if (!this.isRowAvailable()) {
                boolean bl = false;
                return bl;
            }
            this.setRowIndex(last);
            boolean bl = this.isRowAvailable();
            return bl;
        }
        finally {
            this.setRowIndex(startIndex);
        }
    }

    public void addRowKeyChangeListener(RowKeyChangeListener listener) {
        if (!this._rowKeyChangeListeners.contains(listener)) {
            this._rowKeyChangeListeners.add(listener);
        }
    }

    public void removeRowKeyChangeListener(RowKeyChangeListener listener) {
        this._rowKeyChangeListeners.remove(listener);
    }

    protected void fireRowKeyChange(RowKeyChangeEvent event) {
        Object oldRowKey = event.getOldRowKey();
        Object newRowKey = event.getNewRowKey();
        if (oldRowKey != null && newRowKey != null && oldRowKey.equals(newRowKey)) {
            return;
        }
        for (RowKeyChangeListener listener : this._rowKeyChangeListeners) {
            listener.onRowKeyChange(event);
        }
    }

    @Override
    public boolean areRowsLocallyAvailable(int startIndex, int rowsToCheck) {
        return false;
    }

    @Override
    public boolean areRowsLocallyAvailable(Object startRowKey, int rowsToCheck) {
        return false;
    }

    @Override
    public boolean areRowsLocallyAvailable(int rowsToCheck) {
        boolean available = false;
        int startIndex = this.getRowIndex();
        if (startIndex >= 0) {
            available = this.areRowsLocallyAvailable(startIndex, rowsToCheck);
        }
        return available;
    }

    @Override
    public boolean isRowLocallyAvailable(int rowIndex) {
        return false;
    }

    @Override
    public boolean isRowLocallyAvailable(Object rowKey) {
        return false;
    }

    @Override
    public int getEstimatedRowCount() {
        return this.getRowCount();
    }

    @Override
    public LocalRowKeyIndex.Confidence getEstimatedRowCountConfidence() {
        return LocalRowKeyIndex.Confidence.EXACT;
    }

    @Override
    public void clearCachedRow(int index) {
        this.clearCachedRows(index, 1);
    }

    @Override
    public void clearCachedRow(Object rowKey) {
        this.clearCachedRows(rowKey, 1);
    }

    @Override
    public void clearCachedRows(int startingIndex, int rowsToClear) {
        this.clearLocalCache();
    }

    @Override
    public void clearCachedRows(Object startingRowKey, int rowsToClear) {
        this.clearLocalCache();
    }

    @Override
    public void clearLocalCache() {
    }

    @Override
    public LocalRowKeyIndex.LocalCachingStrategy getCachingStrategy() {
        return LocalRowKeyIndex.LocalCachingStrategy.NONE;
    }
}

