/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelLabelAndMessage;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

public class PanelLabelAndMessageRenderer
extends LabelAndMessageRenderer {
    private PropertyKey _forKey;
    private PropertyKey _labelInlineStyleKey;

    public PanelLabelAndMessageRenderer() {
        super(CorePanelLabelAndMessage.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._forKey = type.findKey("for");
        this._labelInlineStyleKey = type.findKey("labelStyle");
    }

    @Override
    protected boolean labelShowRequired(UIComponent component, FacesBean bean) {
        return this.getShowRequired(component, bean);
    }

    @Override
    protected boolean isLeafRenderer() {
        return false;
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|panelLabelAndMessage";
    }

    @Override
    protected String getLabelFor(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        UIComponent child;
        String forValue = this.getFor(component, bean);
        String val = null;
        if (forValue != null) {
            val = MessageUtils.getClientIdFor(context, component, forValue);
        } else if (component.getChildCount() > 0 && (child = this.findForComponent(context, rc, component, bean)) != null) {
            val = child.getClientId(context);
        }
        return val;
    }

    @Override
    protected void renderFieldCellContents(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("table", component);
        OutputUtils.renderLayoutTableAttributes(context, rc, "0", null);
        UIComponent end = PanelLabelAndMessageRenderer.getFacet((UIComponent)component, (String)"end");
        rw.startElement("tr", null);
        rw.startElement("td", null);
        this.encodeAllChildren(context, component);
        rw.endElement("td");
        if (end != null && !PanelLabelAndMessageRenderer.supportsNarrowScreen(rc)) {
            rw.startElement("td", null);
            this.encodeChild(context, end);
            rw.endElement("td");
        }
        rw.endElement("tr");
        rw.endElement("table");
    }

    protected String getFor(UIComponent component, FacesBean bean) {
        return PanelLabelAndMessageRenderer.toString((Object)bean.getProperty(this._forKey));
    }

    @Override
    protected String getLabelInlineStyleKey(UIComponent component, FacesBean bean) {
        return PanelLabelAndMessageRenderer.toString((Object)bean.getProperty(this._labelInlineStyleKey));
    }

    protected UIComponent findForComponent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) {
        UIComponent child;
        Iterator i$ = component.getChildren().iterator();
        while (i$.hasNext()) {
            UIComponent obj;
            child = obj = (UIComponent)i$.next();
            if (!(obj instanceof EditableValueHolder)) continue;
            return child;
        }
        for (UIComponent obj : component.getChildren()) {
            child = obj;
            UIComponent result = this.findForComponent(context, arc, child, bean);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected void renderEndFacetForNarrowPDA(FacesContext context, RenderingContext rc, UIComponent component, boolean insideTableData) throws IOException {
        if (!PanelLabelAndMessageRenderer.supportsNarrowScreen(rc)) {
            return;
        }
        UIComponent end = PanelLabelAndMessageRenderer.getFacet((UIComponent)component, (String)"end");
        if (end != null) {
            ResponseWriter rw = context.getResponseWriter();
            if (insideTableData) {
                rw.startElement("div", null);
                this.encodeChild(context, end);
                rw.endElement("div");
            } else {
                rw.startElement("tr", null);
                rw.startElement("td", null);
                this.encodeChild(context, end);
                rw.endElement("td");
                rw.endElement("tr");
            }
        }
    }
}

