/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlFrame;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class FrameRenderer
extends XhtmlRenderer {
    private PropertyKey _marginWidthKey;
    private PropertyKey _marginHeightKey;
    private PropertyKey _sourceKey;
    private PropertyKey _longDescUrlKey;
    private PropertyKey _scrollingKey;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FrameRenderer.class);

    public FrameRenderer() {
        this(HtmlFrame.TYPE);
    }

    protected FrameRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._marginWidthKey = type.findKey("marginWidth");
        this._marginHeightKey = type.findKey("marginHeight");
        this._sourceKey = type.findKey("source");
        this._longDescUrlKey = type.findKey("longDescURL");
        this._scrollingKey = type.findKey("scrolling");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.renderShortDescAttribute(context, rc, component, bean);
        this.renderStyleAttributes(context, rc, component, bean);
        writer.writeAttribute("frameborder", (Object)"0", null);
        writer.writeAttribute("marginwidth", this.getMarginWidth(component, bean), "marginWidth");
        writer.writeAttribute("marginheight", this.getMarginHeight(component, bean), "marginHeight");
        writer.writeAttribute("noresize", (Object)Boolean.TRUE, null);
        String source = FrameRenderer.toResourceUri((FacesContext)context, (Object)bean.getProperty(this._sourceKey));
        this.renderEncodedActionURI(context, "src", source);
        String longDesc = FrameRenderer.toResourceUri((FacesContext)context, (Object)bean.getProperty(this._longDescUrlKey));
        this.renderEncodedActionURI(context, "longdesc", longDesc);
        writer.writeAttribute("scrolling", bean.getProperty(this._scrollingKey), "scrolling");
    }

    protected Object getMarginWidth(UIComponent component, FacesBean bean) {
        Object value = bean.getProperty(this._marginWidthKey);
        if (value == null) {
            value = this._marginWidthKey.getDefault();
        }
        return value;
    }

    protected Object getMarginHeight(UIComponent component, FacesBean bean) {
        Object value = bean.getProperty(this._marginHeightKey);
        if (value == null) {
            value = this._marginHeightKey.getDefault();
        }
        return value;
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeAttribute("id", (Object)clientId, "id");
            context.getResponseWriter().writeAttribute("name", (Object)clientId, "id");
        }
    }

    protected final void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        UIComponent parent = component.getParent();
        if (parent == null || !"org.apache.myfaces.trinidad.FrameBorderLayout".equals(parent.getFamily())) {
            _LOG.warning("FRAMES_MUST_INSIDE_FRAMEBORDERLAYOUTS");
        } else {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("frame", component);
            this.renderId(context, component);
            this.renderAllAttributes(context, rc, component, bean);
            writer.endElement("frame");
        }
    }
}

