/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.encode;

import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.util.MapArea;
import org.apache.myfaces.trinidadinternal.image.xml.ImageProviderRequestUtils;
import org.apache.myfaces.trinidadinternal.image.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.image.xml.encode.XMLEncoder;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

public abstract class AbstractXMLEncoder
implements XMLEncoder,
ImageConstants,
XMLConstants {
    @Override
    public void encodeXML(ImageContext context, String namespaceURI, String localName, Map<Object, Object> properties, Map<Object, Object> responseProperties, PrintWriter out) {
        AbstractXMLEncoder.encodeStartTag(localName, false, false, out);
        this.encodeAttributes(context, properties, responseProperties, out);
        if (!"http://myfaces.apache.org/uix/image".equals(namespaceURI)) {
            AbstractXMLEncoder.encodeAttribute("xmlns", namespaceURI, out);
        }
        AbstractXMLEncoder.encodeClose(false, out);
        this.encodeBody(context, properties, responseProperties, out);
        AbstractXMLEncoder.encodeEndTag(localName, out);
    }

    protected void encodeAttributes(ImageContext context, Map<Object, Object> properties, Map<Object, Object> responseProperties, PrintWriter out) {
        String type;
        Object o = properties.get(TEXT_ANTIALIAS_KEY);
        if (o != null) {
            AbstractXMLEncoder.encodeBooleanAttribute("textAntialias", (Boolean)o, out);
        }
        if ((o = properties.get(DISABLED_KEY)) != null) {
            AbstractXMLEncoder.encodeBooleanAttribute("disabled", (Boolean)o, out);
        }
        if ((o = responseProperties.get(WIDTH_RESPONSE_KEY)) != null) {
            AbstractXMLEncoder.encodeIntegerAttribute("width", (Integer)o, out);
        }
        if ((o = responseProperties.get(HEIGHT_RESPONSE_KEY)) != null) {
            AbstractXMLEncoder.encodeIntegerAttribute("height", (Integer)o, out);
        }
        if ((o = properties.get(ENCODING_TYPE_KEY)) != null && !"image/gif".equals(type = (String)o)) {
            AbstractXMLEncoder.encodeAttribute("type", type, out);
        }
        this._encodeDirectionAttribute(context, properties, out);
    }

    protected void encodeBody(ImageContext context, Map<Object, Object> properties, Map<Object, Object> responseProperties, PrintWriter out) {
        Color color;
        Object o = properties.get(FOREGROUND_KEY);
        if (o != null) {
            AbstractXMLEncoder.encodeColor("foreground", (Color)o, out);
        }
        if ((o = properties.get(BACKGROUND_KEY)) != null) {
            AbstractXMLEncoder.encodeColor("background", (Color)o, out);
        }
        if ((o = properties.get(SURROUNDING_COLOR_KEY)) != null && (color = (Color)o).getAlpha() != 0) {
            AbstractXMLEncoder.encodeColor("surroundingColor", color, out);
        }
        if ((o = properties.get(FONT_KEY)) != null) {
            AbstractXMLEncoder.encodeFont("font", o, out);
        }
        if ((o = responseProperties.get(IMAGE_MAP_AREAS_RESPONSE_KEY)) != null) {
            ImageProviderRequestUtils.encodeImageMapAreas(context, null, "imageMap", (MapArea[])o, out);
        }
    }

    protected static void encodeColor(String name, Color color, PrintWriter out) {
        AbstractXMLEncoder.encodeStartTag(name, false, false, out);
        AbstractXMLEncoder.encodeAttribute("red", IntegerUtils.getString((int)color.getRed()), out);
        AbstractXMLEncoder.encodeAttribute("green", IntegerUtils.getString((int)color.getGreen()), out);
        AbstractXMLEncoder.encodeAttribute("blue", IntegerUtils.getString((int)color.getBlue()), out);
        AbstractXMLEncoder.encodeClose(true, out);
    }

    protected static void encodeFont(String name, Object font, PrintWriter out) {
        assert (font instanceof FontProxy || font instanceof Font);
        String family = null;
        int style = 0;
        int size = 0;
        if (font instanceof Font) {
            family = ((Font)font).getName();
            style = ((Font)font).getStyle();
            size = ((Font)font).getSize();
        } else {
            FontProxy proxy = (FontProxy)font;
            family = proxy.getName();
            style = proxy.getStyle();
            size = proxy.getSize();
        }
        AbstractXMLEncoder.encodeStartTag(name, out);
        AbstractXMLEncoder.encodeValueTag("name", family, out);
        AbstractXMLEncoder.encodeValueTag("size", Integer.toString(size), out);
        if (style == 0) {
            AbstractXMLEncoder.encodeValueTag("style", "plain", out);
        } else {
            if ((style & 1) != 0) {
                AbstractXMLEncoder.encodeValueTag("style", "bold", out);
            }
            if ((style & 2) != 0) {
                AbstractXMLEncoder.encodeValueTag("style", "italic", out);
            }
        }
        AbstractXMLEncoder.encodeEndTag(name, out);
    }

    protected static void encodeStartTag(String name, PrintWriter out) {
        AbstractXMLEncoder.encodeStartTag(name, true, false, out);
    }

    protected static void encodeStartTag(String name, boolean close, boolean end, PrintWriter out) {
        out.print('<');
        out.print(name);
        if (close) {
            AbstractXMLEncoder.encodeClose(end, out);
        }
    }

    protected static void encodeClose(boolean end, PrintWriter out) {
        if (end) {
            out.println("/>");
        } else {
            out.println('>');
        }
    }

    protected static void encodeEndTag(String name, PrintWriter out) {
        out.print("</");
        out.print(name);
        out.println('>');
    }

    protected static void encodeBooleanAttribute(String name, Boolean value, PrintWriter out) {
        AbstractXMLEncoder.encodeAttribute(name, Boolean.TRUE.equals(value) ? "true" : "false", out);
    }

    protected static void encodeIntegerAttribute(String name, Integer value, PrintWriter out) {
        AbstractXMLEncoder.encodeAttribute(name, IntegerUtils.getString((int)value), out);
    }

    protected static void encodeAttribute(String name, String value, PrintWriter out) {
        out.print(' ');
        out.print(name);
        out.print("=\"");
        AbstractXMLEncoder.encodeText(value, out);
        out.print('\"');
    }

    protected static void encodeValueTag(String name, String value, PrintWriter out) {
        out.print('<');
        out.print(name);
        out.print('>');
        AbstractXMLEncoder.encodeText(value, out);
        AbstractXMLEncoder.encodeEndTag(name, out);
    }

    protected static void encodeBooleanValueTag(String name, Boolean value, PrintWriter out) {
        AbstractXMLEncoder.encodeValueTag(name, value.toString(), out);
    }

    protected static void encodeText(String value, PrintWriter out) {
        if (value != null) {
            char ch;
            int i;
            int length = value.length();
            for (i = 0; i < length && (ch = value.charAt(i)) != '&' && ch != '<' && ch != '>' && ch != '\"'; ++i) {
            }
            if (i == length) {
                out.print(value);
            } else {
                for (i = 0; i < length; ++i) {
                    ch = value.charAt(i);
                    if (ch == '&') {
                        out.print("&amp;");
                        continue;
                    }
                    if (ch == '<') {
                        out.print("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        out.print("&gt;");
                        continue;
                    }
                    if (ch == '\"') {
                        out.print("&quot;");
                        continue;
                    }
                    out.print(ch);
                }
            }
        }
    }

    private final void _encodeDirectionAttribute(ImageContext context, Map<Object, Object> properties, PrintWriter out) {
        int direction = LocaleUtils.getReadingDirection(context.getLocaleContext());
        Integer value = (Integer)properties.get(DIRECTION_KEY);
        if (value != null && value != 0) {
            direction = value;
        }
        if (direction == 1) {
            AbstractXMLEncoder.encodeAttribute("direction", "ltr", out);
        } else if (direction == 2) {
            AbstractXMLEncoder.encodeAttribute("direction", "rtl", out);
        }
    }
}

