/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidadinternal.skin.DocumentProviderSkin;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.cache.FileSystemStyleCache;
import org.apache.myfaces.trinidadinternal.style.xml.StyleSheetDocumentUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinStyleProvider
extends FileSystemStyleCache {
    private Skin _skin;
    private StyleSheetDocument _skinDocument;
    private static final Map<ProviderKey, StyleProvider> _sSharedProviders = new HashMap<ProviderKey, StyleProvider>(31);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinStyleProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StyleProvider getSkinStyleProvider(Skin skin, String targetDirectoryPath) throws IllegalArgumentException {
        if (skin == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_SKIN_SPECIFIED"));
        }
        if (skin instanceof RequestSkinWrapper) {
            skin = ((RequestSkinWrapper)skin).getWrappedSkin();
        }
        ProviderKey key = new ProviderKey(skin, targetDirectoryPath);
        Map<ProviderKey, StyleProvider> providers = SkinStyleProvider._getProviders();
        StyleProvider provider = null;
        Map<ProviderKey, StyleProvider> map = providers;
        synchronized (map) {
            provider = providers.get(key);
            if (provider == null) {
                provider = new SkinStyleProvider(skin, targetDirectoryPath);
                if (_LOG.isFine()) {
                    _LOG.fine("Create a new SkinStyleProvider for skin {0} and targetDirectoryPath {1}", new Object[]{skin.getId(), targetDirectoryPath});
                }
                providers.put(key, provider);
            }
        }
        return provider;
    }

    protected SkinStyleProvider(Skin skin, String targetDirectoryPath) throws IllegalArgumentException {
        super(targetDirectoryPath);
        if (skin == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_SKIN_SPECIFIED"));
        }
        this._skin = skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StyleSheetDocument createStyleSheetDocument(StyleContext context) {
        StyleSheetDocument customDocument = super.createStyleSheetDocument(context);
        StyleSheetDocument skinDocument = null;
        SkinStyleProvider skinStyleProvider = this;
        synchronized (skinStyleProvider) {
            skinDocument = this._skinDocument = ((DocumentProviderSkin)this._skin).getStyleSheetDocument(context);
        }
        return StyleSheetDocumentUtils.mergeStyleSheetDocuments(skinDocument, customDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasSourceDocumentChanged(StyleContext context) {
        if (super.hasSourceDocumentChanged(context)) {
            return true;
        }
        SkinStyleProvider skinStyleProvider = this;
        synchronized (skinStyleProvider) {
            return this._skinDocument != ((DocumentProviderSkin)this._skin).getStyleSheetDocument(context);
        }
    }

    @Override
    protected String getTargetStyleSheetName(StyleContext context, StyleSheetDocument document) {
        String name = super.getTargetStyleSheetName(context, document);
        String id = this._skin.getId();
        if (id != null) {
            StringBuffer buffer = new StringBuffer(id.length() + name.length() + 1);
            buffer.append(id.replace('.', '-'));
            buffer.append('-');
            buffer.append(name);
            return buffer.toString();
        }
        return name;
    }

    private static Map<ProviderKey, StyleProvider> _getProviders() {
        return _sSharedProviders;
    }

    private static class ProviderKey {
        private Skin _skin;
        private String _targetDirectoryPath;

        public ProviderKey(Skin skin, String targetDirectoryPath) {
            this._skin = skin;
            this._targetDirectoryPath = targetDirectoryPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProviderKey)) {
                return false;
            }
            ProviderKey key = (ProviderKey)o;
            return this._equals(this._skin, key._skin) && this._equals(this._targetDirectoryPath, key._targetDirectoryPath);
        }

        public int hashCode() {
            int hashCode = this._skin.hashCode();
            if (this._targetDirectoryPath != null) {
                hashCode ^= this._targetDirectoryPath.hashCode();
            }
            return hashCode;
        }

        private boolean _equals(Object o1, Object o2) {
            if (o1 == null) {
                return o1 == o2;
            }
            return o1.equals(o2);
        }
    }
}

