/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.io.FileInputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.URLInputStreamProvider;

public class DefaultNameResolver
implements NameResolver {
    private DefaultNameResolver _root;
    private File _baseFile;
    private URL _baseURL;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DefaultNameResolver.class);

    public DefaultNameResolver(File baseFile, URL baseURL) {
        if (baseFile != null) {
            if (!baseFile.isDirectory()) {
                baseFile = baseFile.getParentFile();
            }
            this._baseFile = baseFile;
        }
        this._baseURL = baseURL;
    }

    public InputStreamProvider getProvider(String name) throws IOException {
        File file;
        if (DefaultNameResolver._isRoot(name)) {
            try {
                return this._getRootResolver().getProvider(DefaultNameResolver._getRootName(name));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if ((file = this.getFile(name)) != null) {
            return this.__getProvider(file);
        }
        URL url = this.getURL(name);
        if (url != null) {
            return this.__getProvider(url);
        }
        throw new FileNotFoundException(_LOG.getMessage("CANNOT_FIND_FILE", (Object)name));
    }

    public final NameResolver getResolver(String name) {
        if (DefaultNameResolver._isRoot(name)) {
            return this._getRootResolver().getResolver(DefaultNameResolver._getRootName(name));
        }
        DefaultNameResolver base = this.getResolverImpl(name);
        if (base != null) {
            DefaultNameResolver root = this._root;
            if (root == null) {
                root = this;
            }
            base.__setRootResolver(root);
        } else {
            base = this;
        }
        return base;
    }

    public final NameResolver getRootResolver(String name) {
        NameResolver resolver = this.getResolver(name);
        if (resolver instanceof DefaultNameResolver) {
            ((DefaultNameResolver)resolver).__setRootResolver(null);
        }
        return resolver;
    }

    public String toString() {
        String val = super.toString() + "[";
        if (this._baseFile != null) {
            val = val + this._baseFile.toString();
        }
        if (this._baseURL != null) {
            if (this._baseFile != null) {
                val = val + ",";
            }
            val = val + this._baseURL.toString();
        }
        return val + "]";
    }

    protected File getFile(String name) {
        File basePath;
        File file;
        if (name == null) {
            return null;
        }
        if (name.indexOf(47) >= 0 && File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        if (!(file = new File(basePath = this._baseFile, name)).exists()) {
            file = null;
            if (basePath != null && !(file = new File(name)).exists()) {
                file = null;
            }
        }
        return file;
    }

    protected URL getURL(String name) {
        URL url;
        if (name == null) {
            return null;
        }
        try {
            url = name.startsWith("http:") || name.startsWith("https:") || name.startsWith("file:") || name.startsWith("ftp:") || name.startsWith("jar:") ? new URL(name) : (this._baseURL != null ? new URL(this._baseURL, name) : null);
        }
        catch (MalformedURLException mue) {
            url = null;
        }
        return url;
    }

    protected DefaultNameResolver getResolverImpl(String name) {
        File file = this.getFile(name);
        if (file != null) {
            return new DefaultNameResolver(file, null);
        }
        URL url = this.getURL(name);
        if (url != null) {
            return new DefaultNameResolver(null, url);
        }
        return null;
    }

    protected InputStreamProvider getProvider(File file) {
        return new FileInputStreamProvider(file);
    }

    protected InputStreamProvider getProvider(URL url) {
        return new URLInputStreamProvider(url);
    }

    InputStreamProvider __getProvider(File file) {
        DefaultNameResolver root = this._root;
        if (root != null) {
            return root.__getProvider(file);
        }
        return this.getProvider(file);
    }

    InputStreamProvider __getProvider(URL url) {
        DefaultNameResolver root = this._root;
        if (root != null) {
            return root.__getProvider(url);
        }
        return this.getProvider(url);
    }

    void __setRootResolver(DefaultNameResolver root) {
        this._root = root;
    }

    private DefaultNameResolver _getRootResolver() {
        if (this._root == null) {
            return this;
        }
        return this._root;
    }

    private static boolean _isRoot(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return name.charAt(0) == '/';
    }

    private static String _getRootName(String name) {
        return name.substring(1);
    }
}

