/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RowData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public class CellUtils {
    public static final String[] BORDER_CLASS = new String[]{null, "OraTableBorder0001", "OraTableBorder0010", "OraTableBorder0011", "OraTableBorder0100", "OraTableBorder0101", "OraTableBorder0110", "OraTableBorder0111", "OraTableBorder1000", "OraTableBorder1001", "OraTableBorder1010", "OraTableBorder1011", "OraTableBorder1100", "OraTableBorder1101", "OraTableBorder1110", "OraTableBorder1111"};

    public static void renderHeaderAttrs(FacesContext context, TableRenderingContext tContext, Object abbreviation, Object width, boolean isNoWrap, boolean isColumnHeader) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("abbr", abbreviation, null);
        if (!tContext.isExplicitHeaderIDMode()) {
            writer.writeAttribute("scope", (Object)(isColumnHeader ? "col" : "row"), null);
        }
        writer.writeAttribute("width", width, null);
        if (isNoWrap) {
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
    }

    public static void renderSpan(FacesContext rContext, boolean isRowSpan, int value) throws IOException {
        if (value > 1) {
            ResponseWriter writer = rContext.getResponseWriter();
            writer.writeAttribute(isRowSpan ? "rowspan" : "colspan", (Object)value, null);
        }
    }

    public static String getHeaderBorderStyle(TableRenderingContext tContext, RenderingContext afContext, boolean isColumnHeader, boolean isSortable) {
        ColumnData colData = tContext.getColumnData();
        RowData rowData = tContext.getRowData();
        String style = null;
        if (isColumnHeader) {
            int physicalIndex = colData.getPhysicalColumnIndex();
            if (!isSortable) {
                boolean right;
                boolean left;
                boolean bottom;
                if (colData.isColumnGroupHeader()) {
                    if (physicalIndex == 0) {
                        bottom = true;
                        left = false;
                        right = false;
                    } else {
                        bottom = true;
                        left = true;
                        right = false;
                    }
                } else {
                    bottom = false;
                    if (afContext.isRightToLeft()) {
                        right = physicalIndex == tContext.getActualColumnCount() - 1 ? false : tContext.hasGrid(physicalIndex, true);
                        left = false;
                    } else {
                        left = physicalIndex > 0 && tContext.hasGrid(physicalIndex, true);
                        right = false;
                    }
                }
                style = CellUtils.getBorderClass(false, left, bottom, right);
            }
        } else {
            int logicalIndex = rowData.getRangeIndex();
            if (logicalIndex == 0 && tContext.hasColumnHeaders() || logicalIndex > 0 && tContext.hasGrid(logicalIndex, false)) {
                style = CellUtils.getBorderClass(true, false, false, false);
            }
        }
        return style;
    }

    public static String getDataBorderStyle(RenderingContext arc, TableRenderingContext tContext) {
        boolean right;
        ColumnData colData = tContext.getColumnData();
        RowData rowData = tContext.getRowData();
        int physicalColumn = colData.getPhysicalColumnIndex();
        int row = rowData.getRangeIndex();
        if (tContext.getTableHeight() != null && XhtmlRenderer.isGecko((RenderingContext)arc)) {
            return CellUtils.getBorderClass(false, false, false, false);
        }
        boolean supportsCollapse = true;
        int nextRow = row + 1;
        int lastColumnIndex = tContext.getActualColumnCount() - 1;
        boolean top = row == 0;
        boolean left = physicalColumn == 0 || tContext.hasGrid(physicalColumn, true);
        boolean bottom = tContext.hasGrid(nextRow, false);
        if (left && bottom && supportsCollapse) {
            if (!top) {
                top |= tContext.hasGrid(row, false);
            }
            if (top) {
                right = tContext.hasGrid(physicalColumn + 1, true);
                if (!right) {
                    top &= !tContext.hasColumnHeaders();
                }
            } else {
                right = physicalColumn == lastColumnIndex;
            }
        } else {
            top &= !tContext.hasColumnHeaders();
            right = physicalColumn == lastColumnIndex;
        }
        return CellUtils.getBorderClass(top, left, bottom, right);
    }

    public static String getBorderClass(boolean top, boolean left, boolean bottom, boolean right) {
        int offset = CellUtils._getOffset(top, left, bottom, right);
        return BORDER_CLASS[offset];
    }

    private static int _getOffset(boolean top, boolean left, boolean bottom, boolean right) {
        int offset = 0;
        if (top) {
            offset += 8;
        }
        if (right) {
            offset += 4;
        }
        if (bottom) {
            offset += 2;
        }
        if (left) {
            ++offset;
        }
        return offset;
    }

    protected CellUtils() {
    }
}

