/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.autoscroll;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class AutoscrollHiddenFieldRenderer
extends HtmlRenderer {
    private static final String SCROLL_HIDDEN_INPUT = "org.apache.myfaces.SCROLL_HIDDEN_INPUT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        component.popComponentFromEL(context);
        try {
            UIComponent form = UIComponent.getCurrentComponent((FacesContext)context);
            if (form instanceof UIForm) {
                ResponseWriter writer = context.getResponseWriter();
                if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isAutoScroll()) {
                    HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(form, context, writer);
                } else {
                    HtmlRendererUtils.renderAutoScrollHiddenInput(context, writer);
                    context.getExternalContext().getRequestMap().put(AutoscrollHiddenFieldRenderer.getScrollHiddenInputName(context, form), Boolean.TRUE);
                }
            }
        }
        finally {
            component.pushComponentToEL(context, component);
        }
    }

    private static String getScrollHiddenInputName(FacesContext facesContext, UIComponent form) {
        StringBuffer buf = new StringBuffer();
        buf.append(SCROLL_HIDDEN_INPUT);
        buf.append("_");
        buf.append(form.getClientId(facesContext));
        return buf.toString();
    }
}

